/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef _BBTKSIMPLEUTILITIES_H_
#define _BBTKSIMPLEUTILITIES_H_


#include "vtkVersion.h"

#include <time.h>
#include <vtkType.h>
#include <vtkImageData.h>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <time.h>
#include <fstream>



namespace bbtk
{



template <typename T>
class Memcache
{
public:
	vtkImageData* db;

	Memcache()
	{
		db = NULL;
	}

	~Memcache()
	{
		if (db!=NULL)
			db->Delete();
	}

	void init(int x, int y, int z)
	{
		//Se pregunta al OS el tamanio de la palabra de un apuntador
		int palabra = sizeof(T);
		db = vtkImageData::New();
		db->SetDimensions(x,y,z);
		db->SetOrigin(0, 0, 0);

//EED 2017-01-01 Migration VTK7
#if (VTK_MAJOR_VERSION <= 5) 
		db->SetScalarType(Memcache::darTipo(palabra));
		db->AllocateScalars();
		db->Update();
#endif
#if (VTK_MAJOR_VERSION >= 6) 
		db->AllocateScalars(Memcache::darTipo(palabra),1);
#endif


	}
	void* get(int x, int y, int z)
	{
		T* apap = (T*)db->GetScalarPointer(x,y,z);
		void* ap = (void*)*apap;
		return ap;
	}

	void* pop(int x, int y, int z)
	{
		T* apap = (T*)db->GetScalarPointer(x,y,z);
		void* ap = (void*)*apap;
		*apap = NULL;
		return ap;
	}

	void put(int x, int y, int z, void* apt)
	{
		T* punto = (T*)db->GetScalarPointer(x,y,z);
		*punto = (T)apt;
	}
	void clear()
	{
		int ext[6];
		db->GetExtent(ext);
		T* ap1;
		for (int i=ext[0]; i<=ext[1]; i++)
		{
			for (int j=ext[2]; j<=ext[3]; j++)
			{
				for (int k=ext[4]; k<=ext[5]; k++)
				{
					ap1 = (T*)db->GetScalarPointer(i,j,k);
					*ap1 = NULL;
				}
			}
		}
	}
	static int darTipo(int tamanio)
	{
		if (tamanio == sizeof(char))
			return VTK_CHAR;
		if (tamanio == sizeof(unsigned char))
			return VTK_UNSIGNED_CHAR;
		if (tamanio == sizeof(short))
			return VTK_SHORT;
		if (tamanio == sizeof(unsigned short))
			return VTK_UNSIGNED_SHORT;
		if (tamanio == sizeof(int))
			return VTK_INT;
		if (tamanio == sizeof(unsigned int))
			return VTK_UNSIGNED_INT;
		if (tamanio == sizeof(long))
			return VTK_LONG;
		if (tamanio == sizeof(unsigned long))
			return VTK_UNSIGNED_LONG;
		if (tamanio == sizeof(float))
			return VTK_FLOAT;
		if (tamanio == sizeof(double))
			return VTK_DOUBLE;
		return 0;
	}

};


class tiempo
{
	public:
	static time_t first, second;
    static double bytes;
static void tic(vtkImageData* img)
	{
		tiempo::bytes = VTK_SIZE(img);
		tiempo::first = time (NULL);
	}
	static void tic(int bytes_=0)
	{
		tiempo::bytes = bytes_;
		tiempo::first = time (NULL);
	}

	static void toc()
	{
		tiempo::second = time (NULL);
		double diferencia = difftime (tiempo::second,tiempo::first);
		printf ("Total time for %f Bytes is %f (%f Bytes/s)\n", tiempo::bytes, diferencia, tiempo::bytes/diferencia);
	}

	static int VTK_SIZE(vtkImageData* img)
	{
		int dims[3];
		img->GetDimensions(dims);
		int tamanio = VTK_SIZE_T(img->GetScalarType());
		std::cout << "[" << dims[0] << "x" << dims[1] << "x" << dims[2] << "x" << tamanio << "]" << std::endl;
		return dims[0]*dims[1]*dims[2]*tamanio;
	}
	static int VTK_SIZE_T(int tipo)
	{
		switch(tipo)
		{
			case VTK_CHAR:
				return sizeof(char);
			break;
			case VTK_UNSIGNED_CHAR:
				return sizeof(unsigned char);
			break;
			case VTK_SHORT:
				return sizeof(short);
			break;
			case VTK_UNSIGNED_SHORT:
				return sizeof(unsigned short);
			break;
			case VTK_INT:
				return sizeof(int);
			break;
			case VTK_UNSIGNED_INT:
				return sizeof(unsigned int);
			break;
			case VTK_LONG:
				return sizeof(long);
			break;
			case VTK_UNSIGNED_LONG:
				return sizeof(unsigned long);
			break;
			case VTK_FLOAT:
				return sizeof(float);
			break;
			case VTK_DOUBLE:
				return sizeof(double);
			break;
			default:
				return 0;
			break;
		}
	}
};

/*
namespace what
{
           std::string kind(int*);
           std::string is(int*, bool withkind=false);
           std::string kind(double* a);
           std::string is(double* a, bool withkind=false);
           std::string kind(float* a);
           std::string is(float* a, bool withkind=false);
           std::string kind(char* a);
           std::string is(char* a, bool withkind=false);
           std::string kind(long* a);
           std::string is(long* a, bool withkind=false);
           std::string kind(short* a);
           std::string is(short* a, bool withkind=false);
           std::string kind(bool* a);
           std::string is(bool* a, bool withkind=false);
           std::string kind(void* a);
           std::string is(void* a, bool withkind=false);

           std::string kind(unsigned int* a);
           std::string is(unsigned int* a, bool withkind=false);
           std::string kind(unsigned char* a);
           std::string is(unsigned char* a, bool withkind=false);
           std::string kind(unsigned long* a);
           std::string is(unsigned long* a, bool withkind=false);
           std::string kind(unsigned short* a);
           std::string is(unsigned short* a, bool withkind=false);
           std::string kind(__int64* a);
           std::string is(__int64* a, bool withkind=false);
           std::string kind(unsigned __int64* a);
           std::string is(unsigned __int64* a, bool withkind=false);
           std::string kind(long double* a);
           std::string is(long double* a, bool withkind=false);

           std::string kind(int a);
           std::string is(int a, bool withkind=false);
           std::string kind(double a);
           std::string is(double a, bool withkind=false);
           std::string kind(float a);
           std::string is(float a, bool withkind=false);
           std::string kind(short a);
           std::string is(short a, bool withkind=false);
           std::string kind(char a);
           std::string is(char a, bool withkind=false);
           std::string kind(long a);
           std::string is(long a, bool withkind=false);
           std::string kind(bool a);
           std::string is(bool a, bool withkind=false);
           std::string kind(unsigned int a);
           std::string is(unsigned int a, bool withkind=false);
           std::string kind(unsigned char a);
           std::string is(unsigned char a, bool withkind=false);
           std::string kind(unsigned long a);
           std::string is(unsigned long a, bool withkind=false);
           std::string kind(unsigned short a);
           std::string is(unsigned short a, bool withkind=false);
           std::string kind(__int64 a);
           std::string is(__int64 a, bool withkind=false);
           std::string kind(unsigned __int64 a);
           std::string is(unsigned __int64 a, bool withkind=false);
           std::string kind(long double a);
           std::string is(long double a, bool withkind=false);

           std::string kind(std::vector<int> a);
           std::string is(std::vector<int> a, bool withkind=false);
           std::string kind(std::vector<double> a);
           std::string is(std::vector<double> a, bool withkind=false);
           std::string kind(std::vector<float> a);
           std::string is(std::vector<float> a, bool withkind=false);
           std::string kind(std::vector<short> a);
           std::string is(std::vector<short> a, bool withkind=false);
           std::string kind(std::vector<char> a);
           std::string is(std::vector<char> a, bool withkind=false);
           std::string kind(std::vector<long> a);
           std::string is(std::vector<long> a, bool withkind=false);
           std::string kind(std::vector<bool> a);
           std::string is(std::vector<bool> a, bool withkind=false);
           std::string kind(std::vector<__int64> a);
           std::string is(std::vector<__int64> a, bool withkind=false);
           std::string kind(std::vector<unsigned int> a);
           std::string is(std::vector<unsigned int> a, bool withkind=false);
           std::string kind(std::vector<unsigned char> a);
           std::string is(std::vector<unsigned char> a, bool withkind=false);
           std::string kind(std::vector<unsigned long> a);
           std::string is(std::vector<unsigned long> a, bool withkind=false);
           std::string kind(std::vector<unsigned short> a);
           std::string is(std::vector<unsigned short> a, bool withkind=false);
           std::string kind(std::vector<long double> a);
           std::string is(std::vector<long double> a, bool withkind=false);

		   std::string is(double* a,int len=1, bool withkind=false);
		   std::string is(int* a,int len=1, bool withkind=false);
		   std::string is(float* a,int len=1, bool withkind=false);
		   std::string is(char* a,int len=1, bool withkind=false);
}

*/

class persistence
{
    public:
	bool writeFile(std::string stm, std::string content);
	std::string readFile(std::string stm);
};

class logging
{
    public:
	 std::string fecha();
	 void out(std::string texto);
	 void erase();
};

class translate
{
    public:
	/**
	el texto debe ser de la forma [12,45.6] y retorna un vector con la informacion esperada
	**/
	 std::vector<double> stringTovector(std::string, std::string start="[", std::string end="]");
	 /**
	Ayuda a parsear una linea de texto que contiene numeros
	 */
	 std::vector<double> stringTovectorDelimited(std::string, std::string);

	std::string vectorToStringDelimited(std::vector<double> a, std::string delim);
	 std::vector<double*> stringToVectorArray(std::string);
	/**
	StringSplit toma str y lo parte por el delimitador delim y retorna el vector de partes
	**/
	 std::vector<std::string> StringSplit(std::string, std::string);
	/**
	Lo mismo que stringTovector, pero retornando un arreglo en vez de un vector
	**/
	 double* stringToArray(std::string);
	 std::string getInnerInfo(std::string);
//	 std::vector<double*> stringToVectorArray(std::string);
};

class vectores
{
    public:
	//Recorre el vector de manera ciclica
	double vectorInfinite(std::vector<double> in, int index);
};

class sorts
{
    public:
	 void bubble(std::vector<double> &array);
};

}

#endif // _BBTKSIMPLEUTILITIES_H_
