/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkBinaryOperations_h_INCLUDED__
#define __bbvtkBinaryOperations_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "bbtkStaticLecture.h"

#include "vtkVersion.h"

#include <vtkImageMathematics.h>
#include <vtkImageData.h>
#include <vtkType.h>
#include <vtkImageData.h>


namespace bbvtk
{



class bbvtk_EXPORT BinaryOperations
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(BinaryOperations,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(Operation,int);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  void crearPredeterminado();
  void substractWithMinimum();
  void MultiplyBy();

  bbtkStaticLecture lector;

  vtkImageMathematics* ope;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(BinaryOperations,bbtk::AtomicBlackBox);
  BBTK_NAME("BinaryOperations");
  BBTK_AUTHOR("Info-Dev");
  BBTK_DESCRIPTION("Arithmetic operations between two images");
  BBTK_CATEGORY("filter");
  BBTK_INPUT(BinaryOperations,In1,"first image to be operated",vtkImageData*,"NULL default");
  BBTK_INPUT(BinaryOperations,In2,"second image to be operated",vtkImageData*,"NULL default");
  BBTK_INPUT(BinaryOperations,Operation,"0:Add (default) , 1:subtract, 2:multiply, 3:divide, 4=Max, 5=Min, 6=Replace with In1, 7=Replace with In2, 8=DeepCopy de In2 to In1 (output In1)",int,"");
  BBTK_OUTPUT(BinaryOperations,Out,"",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(BinaryOperations);
}
// EO namespace bbSimpleProcessing

#endif // __bbvtkBinaryOperations_h_INCLUDED__


