/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkGetVectorElement.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.4 $
=========================================================================*/

#ifndef __bbvtkGetVectorElement_INCLUDED_h__
#define __bbvtkGetVectorElement_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbvtk_EXPORT.h"

#include "vtkImageData.h"
#include "vtkPolyData.h"

namespace bbvtk
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbvtk_EXPORT GetVectorElement : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(GetVectorElement,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::vector<T>);
    BBTK_DECLARE_INPUT(I,int);
    BBTK_DECLARE_INPUT(ErrorValue,T);
    BBTK_DECLARE_OUTPUT(Out,T);
    BBTK_PROCESS(DoIt);
    void DoIt();
  };
  //=================================================================


  typedef vtkImageData* ptrvtkImageData;
  typedef vtkPolyData* ptrvtkPolyData;

//  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME( ptrvtkImageData ,"PtrvtkImageData");
//  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME( ptrvtkPolyData ,"PtrvtkPolyData");
//  BBTK_DEFINE_HUMAN_READABLE_VECTOR_TYPE_NAME(ptrvtkImageData);
//  BBTK_DEFINE_HUMAN_READABLE_VECTOR_TYPE_NAME(ptrvtkPolyData);

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(GetVectorElement,bbtk::AtomicBlackBox);

  std::string humantypename;
  if (bbtk::HumanTypeName<T>()==bbtk::HumanTypeName<vtkPolyData*>()) { humantypename="VtkPolyData"; }
  if (bbtk::HumanTypeName<T>()==bbtk::HumanTypeName<vtkImageData*>()) { humantypename="VtkImageData"; }
  
  BBTK_NAME("GetVector"+humantypename+"Element");

//  BBTK_NAME("GetVector"+bbtk::HumanTypeName<T>()+"Element");

//  BBTK_NAME("Get"+bbtk::HumanTypeName<std::vector<T> >()+"Element");
//  BBTK_NAME("GetVector"+"T"+"Element");
//   BBTK_NAME("GetVectorVtkImageDataElement");
  BBTK_AUTHOR("info-dev@creatis.insa-lyon.fr");
 // BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("(C++,JavaScript) Gets the i-th element from the input vector ("+bbtk::TypeName<std::vector<T> >());
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_INPUT(GetVectorElement, In,"(default NULL) Input",Tvector);
  BBTK_TEMPLATE_INPUT(GetVectorElement, I, "iElement (default 0)",int);
  BBTK_TEMPLATE_INPUT(GetVectorElement, ErrorValue, "(default NULL) ErrorValue",T);
  BBTK_TEMPLATE_OUTPUT(GetVectorElement,Out,"Output",T);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(GetVectorElement);
  //=================================================================

  //=================================================================
  template <class T>
  void GetVectorElement<T>::DoIt()
  {
	  if (( bbGetInputI() < bbGetInputIn().size() )  &&  ( bbGetInputI() >= 0 ) )
	  {
		  bbSetOutputOut( bbGetInputIn()[bbGetInputI()] );
	  } else
	  {
		  bbSetOutputOut( bbGetInputErrorValue() );
	  }
  }
  //=================================================================

  //=================================================================  
  template <class T>
  void GetVectorElement<T>::bbUserSetDefaultValues()
  {
	bbSetInputI(NULL);
    bbSetInputErrorValue(NULL);
  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetVectorElement<T>::bbUserInitializeProcessing()
  {

  }
  //=================================================================
  //=================================================================  
  template <class T>
  void GetVectorElement<T>::bbUserFinalizeProcessing()
  {

  }
  //=================================================================

} // namespace bbvtk

#endif //__bbvtkGetVectorElement_INCLUDED_h__

