/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkImageCastToUShort_h_INCLUDED__
#define __bbvtkImageCastToUShort_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkVersion.h"

#include "vtkImageData.h"
#include "vtkImageCast.h"

namespace bbvtk
{

class bbvtk_EXPORT ImageCastToUShort
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageCastToUShort,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

private:
	vtkImageCast* cast;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageCastToUShort, bbtk::AtomicBlackBox);
BBTK_NAME("ImageCastToUShort");
BBTK_AUTHOR("car-prie@uniandes.edu.co");
BBTK_DESCRIPTION("Cast an Image to UShort");
BBTK_CATEGORY("filter, image");
BBTK_INPUT(ImageCastToUShort, In, "First input", vtkImageData*, "");
BBTK_OUTPUT(ImageCastToUShort, Out, "First output", vtkImageData*, "");
BBTK_END_DESCRIBE_BLACK_BOX(ImageCastToUShort);
}
// EO namespace bbvtk

#endif // __bbvtkImageCastToUShort_h_INCLUDED__
