/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkMIPCreator.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.11 $
=========================================================================*/

/**
 * \brief Short description in one line
 *
 * Long description which
 * can span multiple lines
 */
/**
 * \file
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern
 * \brief Pattern for the definition of a new type of Node
 */

#ifdef _USE_VTK_

#ifndef __bbvtkMIPCreator_h_INCLUDED__
#define __bbvtkMIPCreator_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"

#include "vtkVersion.h"
#include "vtkImageData.h"
#include <vtkImageShiftScale.h>

//EED 2018-07-20 Migration VTK8
#if (VTK_MAJOR_VERSION <= 7) 
	#include <vtkVolumeRayCastMIPFunction.h>
	#include <vtkVolumeRayCastMapper.h>
#else 
	#include <vtkFixedPointVolumeRayCastMapper.h>
#endif


#include "vtkProp3D.h"
#include "vtkVolume.h"

#include "bbvtk_EXPORT.h"

namespace bbvtk
{
   class bbvtk_EXPORT MIPCreator : public bbtk::AtomicBlackBox
  {
  public:
    BBTK_BLACK_BOX_INTERFACE(MIPCreator,bbtk::AtomicBlackBox);
    //    BBTK_DECLARE_INPUT(Contour,int);
    BBTK_DECLARE_INPUT(In,vtkImageData *);
    BBTK_DECLARE_INPUT(DensityPoints, std::vector<double> );
    BBTK_DECLARE_INPUT(OpacityValues, std::vector<double> );
    BBTK_DECLARE_INPUT(MinColorWindow, double );
    BBTK_DECLARE_INPUT(MaxColorWindow, double );
    BBTK_DECLARE_OUTPUT(Out,vtkProp3D*);
    BBTK_PROCESS(Process);
    void Process();

  protected:
  private:
    std::vector<double> DensityPoints;
    std::vector<double> OpacityValues;
    vtkImageShiftScale			*mCast;


//EED 2018-07-20 Migration VTK8
#if (VTK_MAJOR_VERSION <= 7) 
    vtkVolumeRayCastMIPFunction			*mMIP;
    vtkVolumeRayCastMapper				*mMapper;
#else 
    vtkFixedPointVolumeRayCastMapper	*mMapper;
#endif



    vtkVolume				*mVolume;
    vtkPiecewiseFunction *opacityTransferFunction;
    vtkPiecewiseFunction *grayTransferFunction;
    double scale;
  };

  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(MIPCreator,bbtk::AtomicBlackBox);
  BBTK_NAME("MIPCreator");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Creates a Maximum Intensity Projection (MIP) view of a 3D image. Creates a vtkProp3D object to insert into a 3D scene (e.g. a Viewer3D)");
  BBTK_CATEGORY("3D object creator");
  BBTK_INPUT(MIPCreator,DensityPoints,"Density values of the original image", std::vector<double>,"");
  BBTK_INPUT(MIPCreator,OpacityValues,"Opacity values for the MIP function", std::vector<double>,"");
  BBTK_INPUT(MIPCreator,In,"Input Image",vtkImageData *,"");
  BBTK_INPUT(MIPCreator,MinColorWindow,"Minimum density value for MIP color function", double,"");
  BBTK_INPUT(MIPCreator,MaxColorWindow,"Maximum density value for MIP color function", double,"");
  BBTK_OUTPUT(MIPCreator,Out,"MIP object to plug into a 3D viewer",vtkProp3D*,"");
  BBTK_END_DESCRIBE_BLACK_BOX(MIPCreator);
  //=================================================================

}//namespace bbvtk

#endif  //__bbtvtkMIPCreator_h__

#endif //_USE_VTK_

