/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#ifndef __bbvtkMagnitud_h_INCLUDED__
#define __bbvtkMagnitud_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

// ----------[
#include "vtkActor.h"
#include "vtkAppendPolyData.h"
#include "vtkArrowSource.h"
#include "vtkContourFilter.h"
#include "vtkDiskSource.h"
#include "vtkGlyph3D.h"
#include "vtkImageData.h"
#include "vtkImageExport.h"
#include "vtkLookupTable.h"
#include "vtkMaskPoints.h"
#include "vtkOutlineFilter.h"
#include "vtkPlaneWidget.h"
#include "vtkPlaneSource.h"
#include "vtkPointSource.h"
#include "vtkPointWidget.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkProbeFilter.h"
#include "vtkProp3D.h"
#include "vtkProperty.h"
#include "vtkProperty2D.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkScalarBarActor.h"
#include "vtkStreamTracer.h"
#include "vtkTransform.h"
#include "vtkTransformPolyDataFilter.h"
#include "vtkTubeFilter.h"
#include "vtkVectorNorm.h"

#define SIZEPLANWIDGET 64
// ----------]

namespace bbvtk
{

class bbvtk_EXPORT Magnitud
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(Magnitud,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 

// -------------- [
   BBTK_DECLARE_INPUT(In,vtkImageData*);
   BBTK_DECLARE_INPUT(MoveX,double);
   BBTK_DECLARE_INPUT(MoveY,double);
   BBTK_DECLARE_INPUT(MoveZ,double);
   BBTK_DECLARE_INPUT(ValSup,double);
   BBTK_DECLARE_INPUT(ValInf,double);
   BBTK_DECLARE_INPUT(MRatio,int);
   BBTK_DECLARE_INPUT(Opactity,double);
   BBTK_DECLARE_INPUT(Scale,double);
   BBTK_DECLARE_INPUT(Contour,int);
   BBTK_DECLARE_INPUT(ShowPlane,int);
   BBTK_DECLARE_INPUT(ShowStream,int);
   BBTK_DECLARE_INPUT(PlaneCenterSL,std::vector<double>);

   BBTK_DECLARE_OUTPUT(Out1,vtkProp3D*);
   BBTK_DECLARE_OUTPUT(Out2,vtkProp3D*);
   BBTK_DECLARE_OUTPUT(Out3,vtkProp3D*);
   BBTK_DECLARE_OUTPUT(Out4,vtkProp3D*);
   //BBTK_DECLARE_OUTPUT(Out5,vtkProp*);
   BBTK_DECLARE_OUTPUT(Out5,vtkProp3D*);
   //BBTK_DECLARE_OUTPUT(OutExport,vtkImageExport*);
   //BBTK_DECLARE_OUTPUT(OutTest,vtkImageData*);
// -------------- ]

  BBTK_PROCESS(Process);
  void Process();
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
// -------------- [
   vtkImageData					*temp;
   std::vector<double> 			tempc;

   int 							sizeIma;
   long 						int index;
   double 						p0[3], p1[3],p2[3], n[3], c[3], slCenter[3];
   double 						range[2];
   double 						range1[2];
   double 						step;
   double 						h;
   double 						nx;
   double 						ny;
   double 						nz;
   double 						alfa;
   double 						beta;
   double 						dRangeColorForGlyphVelocity[2];
   double 						dRangeColorForMultipleContourVelocity[2];
   double 						dRangeColorForGlyphVelocityForFlowPlane[2];

   int 							Ratio;
   double 						dOpactity;
   double 						dScale;
   int 							nContour;
   bool 						bShow;
   
   vtkActor						*vGlyphActor;
   vtkActor						*vMultipleContourActor;
   vtkActor						*vOutlineActor;
   vtkActor						*vSliceActor;
   vtkActor						*vStreamlineActor2;
   vtkAppendPolyData			*vAppendDataForFlowWidgetVisualisation;
   vtkArrowSource				*cone;
   vtkArrowSource				*vArrowSource;
   vtkContourFilter				*vMultipleContourVelocity;
   vtkDiskSource				*vDiskSourceEED;
   vtkGlyph3D					*vGlyph;
   vtkGlyph3D					*vGlyphFlowPlane;
   vtkImageExport				*exporter;
   vtkLookupTable				*vGreenToRedLut;
   vtkMaskPoints				*vMaskPoint;
   vtkPlaneSource				*vPlanSource;
   vtkProbeFilter				*vProbeslices;
   vtkProbeFilter				*vProbeslicesFlowWidget;
   vtkPlaneWidget				*vPlaneWidget;
   vtkPolyData					*point;
   vtkPolyDataMapper			*vSliceMapper;
   vtkPointSource				*source;
   vtkPointWidget				*vPointWidget;
   vtkPolyDataMapper			*vGlyphMapper;
   vtkPolyDataMapper			*vMultipleContourMapper;
   vtkOutlineFilter				*vOutlineGrid;
   vtkPolyDataMapper			*vOutlineMapper;
   vtkPolyDataMapper			*streamMapper2;
   vtkRenderWindowInteractor	*vIren;
   vtkScalarBarActor			*vScalarBarActor;
   vtkStreamTracer				*streamer;
   vtkTransform					*transformEED;
   vtkTransformPolyDataFilter	*vtransformpolydatafilter;
   vtkTubeFilter				*rf;
   vtkVectorNorm				*vVecMagnitude;
// -------------- ]

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Magnitud,bbtk::AtomicBlackBox);
BBTK_NAME("Magnitud");
BBTK_AUTHOR("seba-tor@uniandes.edu.co");
BBTK_DESCRIPTION("Receive an ImgaData and generates an Actor. 'EED this box have to be splited in 5 box'");
BBTK_CATEGORY("");
// -------------- [
  BBTK_INPUT(Magnitud,In,"Receive the image source",vtkImageData*, "");
  BBTK_INPUT(Magnitud,MoveX,"Move the PlaneSource - X Axis",double, "");
  BBTK_INPUT(Magnitud,MoveY,"Move the PlaneSource - Y Axis",double, "");
  BBTK_INPUT(Magnitud,MoveZ,"Move the PlaneSource - Z Axis",double, "");
  BBTK_INPUT(Magnitud,ValSup,"Set the Superior Range of the Colour Range: [0% - 100%]",double, "");
  BBTK_INPUT(Magnitud,ValInf,"Set the Inferior Range of the Colour Range: [0% - 100%]",double, "");
  BBTK_INPUT(Magnitud,MRatio,"Set the Radio of the Mask",int, "");
  BBTK_INPUT(Magnitud,Opactity,"Set the Opacity of the Glyph",double, "");
  BBTK_INPUT(Magnitud,Scale,"Set the Scale of the Glyph",double, "");
  BBTK_INPUT(Magnitud,Contour,"Set the Contour Number",int, "");
  BBTK_INPUT(Magnitud,ShowPlane,"Show the PlaneWidget",int, "");
  BBTK_INPUT(Magnitud,ShowStream,"Show the Stream Lines",int, "");
  BBTK_INPUT(Magnitud,PlaneCenterSL,"Center for the Stream Lines",std::vector<double>, "");

  BBTK_OUTPUT(Magnitud,Out1,"Actor1 3D - SliceActor",vtkProp3D*, "");
  BBTK_OUTPUT(Magnitud,Out2,"Actor2 3D - GlyphActor",vtkProp3D*, "");
  BBTK_OUTPUT(Magnitud,Out3,"Actor3 3D - OutlineActor",vtkProp3D*, "");
  BBTK_OUTPUT(Magnitud,Out4,"Actor4 3D - MultipleContourActor",vtkProp3D*, "");
  //BBTK_OUTPUT(Magnitud,Out5,"Actor5 2D - ScalarBarActor",vtkProp*, "");
  BBTK_OUTPUT(Magnitud,Out5,"Actor5 3D - SteamlineActor",vtkProp3D*, "");
  //BBTK_OUTPUT(Magnitud,OutExport,"Exports the Contour Image",vtkImageExport*, "");
  //BBTK_OUTPUT(Magnitud,OutTest,"Test",vtkImageData*, "");
// -------------- ]
BBTK_END_DESCRIBE_BLACK_BOX(Magnitud);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
}
// EO namespace bbvtk

#endif // __bbvtkMagnitud_h_INCLUDED__

