/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkMarchingCubes.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.10 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef _USE_VTK_

#ifndef __bbvtkMarchingCubes_h_INCLUDED__
#define __bbvtkMarchingCubes_h_INCLUDED__


#include "bbtkAtomicBlackBox.h"
#include "vtkVersion.h"

#include "bbtkVtkBlackBoxMacros.h"
#include "vtkMarchingCubes.h"
#include "vtkImageData.h"

namespace bbvtk
{

   //=======================================================================
  class /*BBTK_EXPORT*/ MarchingCubes
    : 
    public bbtk::AtomicBlackBox 
//    ,public vtkMarchingCubes
  {
    BBTK_VTK_BLACK_BOX_INTERFACE(MarchingCubes,
				 bbtk::AtomicBlackBox,
				 vtkMarchingCubes);

	BBTK_DECLARE_INPUT(Active,bool);
    BBTK_DECLARE_VTK_INPUT(In,vtkImageData *);
	BBTK_DECLARE_INPUT(Value,double);
	BBTK_DECLARE_INPUT(ComputeNormalsOn,bool);
	BBTK_DECLARE_INPUT(ComputeScalarsOn,bool);
    BBTK_DECLARE_VTK_OUTPUT(Out,vtkPolyData *);

    // For the 'Value' parameter, the standard bbtk macro does not work 
    // as vtk Get/Set accessors have a parameter...
    //  BBTK_DECLARE_VTK_PARAM(vtkMarchingCubes,Value,double);
    // Hence have to wrap the accessors "by hand" :
	  
	 /* 
    double bbGetInputValue ()
       { return vtkMarchingCubes::GetValue(0); }
    void bbSetInputValue (double d)	
       { // vtkMarchingCubes::SetValue(0,d);
		   
		   mVtkObject->SetValue(0,1000.0);

		   std::cout <<  "EED MarchingCubes::bbSetInputValue " << d << std::endl;
	   
	   }
*/
	  
  // BBTK_VTK_PROCESS();
	  BBTK_PROCESS(Process);
	  void Process();

  };
  //=======================================================================
  
  //=======================================================================
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(MarchingCubes,bbtk::AtomicBlackBox);
  BBTK_NAME("MarchingCubes");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("(C++,Python) Extracts an iso-surface of an image using the marching cubes algorithm (bbfication of vtkMarchingCubes)");
  BBTK_CATEGORY("image;mesh");

  BBTK_INPUT(MarchingCubes,Active,"Active true/false (default true)",bool,"");
  BBTK_INPUT(MarchingCubes,In,"Image",vtkImageData*,"");
  BBTK_INPUT(MarchingCubes,Value,"(default 400) Value of the iso-surface",double,"");
  BBTK_INPUT(MarchingCubes,ComputeNormalsOn,"Set the computation of normals",bool,"");
  BBTK_INPUT(MarchingCubes,ComputeScalarsOn,"Set the computation of scalars",bool,"");
  BBTK_OUTPUT(MarchingCubes,Out,"Output iso-surface",vtkPolyData*,"");
  
  BBTK_END_DESCRIBE_BLACK_BOX(MarchingCubes);
  //=======================================================================

}// EO namespace bbvtk


#endif  //__bbvtkMarchingCubes_h_INCLUDED__

#endif //_USE_VTK_

