/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkTemporalPicker_h_INCLUDED__
#define __bbvtkTemporalPicker_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkVersion.h"
#include "vtkImageData.h"

namespace bbvtk
{

class bbvtk_EXPORT TemporalPicker : public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TemporalPicker,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,vtkImageData*);
    BBTK_DECLARE_INPUT(InLst,std::vector < vtkImageData*> );
    BBTK_DECLARE_INPUT(SizeRegion,int);
    BBTK_DECLARE_INPUT(Point,std::vector<int>);
	BBTK_DECLARE_OUTPUT(Out,std::vector<double>);
  BBTK_PROCESS(Process);

	void Process();
	void Process_TemporaryPicker2DT();
	void Process_TemporaryPicker3DT();

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TemporalPicker,bbtk::AtomicBlackBox);
	BBTK_NAME("TemporalPicker");
	BBTK_AUTHOR("Info-Dev");
	BBTK_DESCRIPTION("Pick vector in Z direction  (2D+t => 3D)");
	BBTK_CATEGORY("");
	BBTK_INPUT(TemporalPicker,In,"In image or InLst images",vtkImageData*,"");
	BBTK_INPUT(TemporalPicker,InLst,"In image or InLst images",std::vector<vtkImageData*>,"");
	BBTK_INPUT(TemporalPicker,SizeRegion,"Size region (default 1)",int,"");
	BBTK_INPUT(TemporalPicker,Point,"Point [x,y]",std::vector<int>,"");
	BBTK_OUTPUT(TemporalPicker,Out,"Output vector with Z information",std::vector<double>,"");
BBTK_END_DESCRIBE_BLACK_BOX(TemporalPicker);
}
// EO namespace bbvtk

#endif // __bbvtkTemporalPicker_h_INCLUDED__


