/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkTransform_h_INCLUDED__
#define __bbvtkTransform_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkTransform.h"
//#include <vtkLinearTransform.h>

namespace bbvtk
{
  
  class /*BBTK_EXPORT*/ Transform
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(Transform,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(Inverse,bool);
    BBTK_DECLARE_INPUT(In,vtkLinearTransform *);
    BBTK_DECLARE_INPUT(Scale,std::vector<double>);
    BBTK_DECLARE_INPUT(RotateWXYZ,std::vector<double>);
    BBTK_DECLARE_INPUT(Translate,std::vector<double>);
    BBTK_DECLARE_INPUT(Spacing,std::vector<double>);
    BBTK_DECLARE_INPUT(RotateToNormal,std::vector<double>);
    BBTK_DECLARE_INPUT(ManualMatrixIn,std::vector<double>);
    BBTK_DECLARE_OUTPUT(Out,vtkLinearTransform *);
    BBTK_DECLARE_OUTPUT(ManualMatrixOut,std::vector<double>);
    BBTK_PROCESS(Process);
    void Process();
    
    std::vector<double>		vecScale;
    std::vector<double>		vecRotateWXYZ;
    std::vector<double>		vecTranslate;
    std::vector<double>		vecSpacing;
    vtkTransform			*result; 
    vtkTransform			*resultInverse; 
};
  
BBTK_BEGIN_DESCRIBE_BLACK_BOX(Transform,bbtk::AtomicBlackBox);
  BBTK_NAME("Transform");
  BBTK_AUTHOR("InfoTeam CREATIS-LRMN");
  BBTK_DESCRIPTION("(C++,Python) vtkTransform");
  BBTK_CATEGORY("math");

  BBTK_INPUT(Transform,Inverse,"(default false)  true/false",bool,"");
  BBTK_INPUT(Transform,In,"vtkTransform to be concatenate",vtkLinearTransform *,"");
  BBTK_INPUT(Transform,Scale,"vector with sx sy sz",std::vector<double>,"");
  BBTK_INPUT(Transform,Translate,"vector with x y z",std::vector<double>,"");
  BBTK_INPUT(Transform,Spacing,"vector with spacingX spacingY spacingZ",std::vector<double>,"");
  BBTK_INPUT(Transform,RotateWXYZ,"vector with Angle Vx Vy Vz",std::vector<double>,"");
  BBTK_INPUT(Transform,RotateToNormal,"(default is EMPTY) Normal vector [nx,ny,nz]",std::vector<double>,"");
  BBTK_INPUT(Transform,ManualMatrixIn,"(default EMPTY) The 16 elements of a 4x4 matrix",std::vector<double>,"");

  BBTK_OUTPUT(Transform,Out,"vtkTransform result",vtkLinearTransform *,"");
  BBTK_OUTPUT(Transform,ManualMatrixOut,"The 16 elements of the 4x4 matrix",std::vector<double>,"");

BBTK_END_DESCRIBE_BLACK_BOX(Transform);
}
// EO namespace bbvtk

#endif // __bbvtkTransform_h_INCLUDED__

