/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkUnMosaic.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.2 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */
 
#ifdef _USE_VTK_

#ifndef __bbvtkUnMosaic_h_INCLUDED__
#define __bbvtkUnMosaic_h_INCLUDED__
#include "bbvtk_EXPORT.h"

#include "bbtkAtomicBlackBox.h"

#include "vtkVersion.h"
#include "vtkImageData.h"

namespace bbvtk
{
  class bbvtk_EXPORT UnMosaic : public bbtk::AtomicBlackBox
  { 
  public:
    BBTK_BLACK_BOX_INTERFACE(UnMosaic, bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT (In,vtkImageData *);
    BBTK_DECLARE_INPUT (NbImagesPerRow,int);
    BBTK_DECLARE_INPUT (NbImagesInMosaic,int);       
    BBTK_DECLARE_OUTPUT(Out, vtkImageData*);    
    BBTK_PROCESS(Process);
    void Process();
  private :
  vtkImageData * unMosaic(vtkImageData *imageIn, int nbImagesPerRow, int numberOfImagesInMosaic);
  protected:
  
  // Attributes :
  private:
     vtkImageData *mImageOut;    
  };

  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(UnMosaic,bbtk::AtomicBlackBox);
  BBTK_NAME("UnMosaic");
  BBTK_AUTHOR("jp at creatis.univ-lyon.fr");
  BBTK_DESCRIPTION("Transforms a 2D (ala Siemens Mosaic) <vtkImageData*> into a 3D vtkImageData");
  BBTK_CATEGORY("application, image");
  BBTK_INPUT(UnMosaic, In, "ala Siemens Mosaic 2D image", vtkImageData *, "");
  BBTK_INPUT(UnMosaic, NbImagesPerRow, "Nb of Images Per Row ", int, ""); 
  BBTK_INPUT(UnMosaic, NbImagesInMosaic, "Nb of Images In Mosaic ", int, "");   
  BBTK_OUTPUT(UnMosaic, Out, "3D Image", vtkImageData *, "");
  BBTK_END_DESCRIBE_BLACK_BOX(UnMosaic);   
  //=================================================================

}//namespace bbvtk
   
#endif  //__bbtvtkUnMosaic_h__
#endif //_USE_VTK_
