/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkUnaryOperations_h_INCLUDED__
#define __bbvtkUnaryOperations_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"


#include "vtkVersion.h"
#include <vtkImageMathematics.h>
#include <vtkImageData.h>
#include <vtkType.h>
#include <vtkImageData.h>
#include <bbtkStaticLecture.h>


namespace bbvtk
{




class bbvtk_EXPORT UnaryOperations
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(UnaryOperations,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(Operation,int);
  BBTK_DECLARE_INPUT(InConstant,double);
  BBTK_DECLARE_INPUT(NewValue,double);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  void crearPredeterminado();
  void substractWithMinimum();
//  void MultiplyBy();

  bbtkStaticLecture lector;

  vtkImageMathematics* ope;
  vtkImageData* constante;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(UnaryOperations,bbtk::AtomicBlackBox);
  BBTK_NAME("UnaryOperations");
  BBTK_AUTHOR("Info-Dev Creatis");
  BBTK_DESCRIPTION("math operation over an image");
  BBTK_CATEGORY("filtre");
  BBTK_INPUT(UnaryOperations,In1,"Image to be operated",vtkImageData*,"");
  BBTK_INPUT(UnaryOperations,InConstant,"Constant that will be used in the operations.",double,"0 default");
  BBTK_INPUT(UnaryOperations,NewValue,"InConstant replace by NewValue",double,"0 default");
  BBTK_INPUT(UnaryOperations,Operation,"0:Add (Default), 1:subtract, 2:multiply, 3:divide, 4:invert, 5:sin, 6:cos, 7:exp, 8:log, 9:abs????, 10:SquareRoot, 11:ReplaceByConstant",int,"Addition default");
  BBTK_OUTPUT(UnaryOperations,Out,"",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(UnaryOperations);
}
// EO namespace bbSimpleProcessing

#endif // __bbvtkUnaryOperations_h_INCLUDED__


