/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkVecImageGaussianSmooth_h_INCLUDED__
#define __bbvtkVecImageGaussianSmooth_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkVersion.h"
#include "vtkImageData.h"
#include "vtkImageGaussianSmooth.h"

#include <vector>

namespace bbvtk
{

class /*BBTK_EXPORT*/ VecImageGaussianSmooth
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(VecImageGaussianSmooth,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,std::vector<vtkImageData*>);
  BBTK_DECLARE_INPUT(StdDevX,double);
  BBTK_DECLARE_INPUT(StdDevY,double);
  BBTK_DECLARE_INPUT(StdDevZ,double);
  BBTK_DECLARE_INPUT(iImage,int);
  BBTK_DECLARE_OUTPUT(Out,std::vector<vtkImageData*>);
  BBTK_DECLARE_OUTPUT(OutImage,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
  
  std::vector<vtkImageGaussianSmooth *> VecVtkimagegaussiansmooth;
  std::vector<vtkImageData*>			VecResult;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(VecImageGaussianSmooth,bbtk::AtomicBlackBox);
BBTK_NAME("VecImageGaussianSmooth");
BBTK_AUTHOR("InfoTeam CREATIS-LRMN");
BBTK_DESCRIPTION("Vector of ImageGaussianSmooth");
BBTK_CATEGORY("filter");


BBTK_INPUT(VecImageGaussianSmooth,In,"Vector of input images",std::vector<vtkImageData*>,"");
BBTK_INPUT(VecImageGaussianSmooth,StdDevX,"Standard deviation in direction X",double,"");
BBTK_INPUT(VecImageGaussianSmooth,StdDevY,"Standard deviation in direction Y",double,"");
BBTK_INPUT(VecImageGaussianSmooth,StdDevZ,"Standard deviation in direction Z",double,"");
BBTK_INPUT(VecImageGaussianSmooth,iImage,"iImage ",int,"");
BBTK_OUTPUT(VecImageGaussianSmooth,Out,"Vector of output images",std::vector<vtkImageData*>,"");
BBTK_OUTPUT(VecImageGaussianSmooth,OutImage,"Image[iImage]",vtkImageData*,"");

BBTK_END_DESCRIBE_BLACK_BOX(VecImageGaussianSmooth);
}
// EO namespace bbvtk

#endif // __bbvtkVecImageGaussianSmooth_h_INCLUDED__

