/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkVecIsoSurfaceExtractor_h_INCLUDED__
#define __bbvtkVecIsoSurfaceExtractor_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"
#include "vtkRenderer.h"
#include "vtkMarchingCubes.h"
#include "vtkPolyDataMapper.h"
#include "vtkProp3D.h"
#include "vtkActor.h"
#include <vector>

namespace bbvtk
{

class /*BBTK_EXPORT*/ VecIsoSurfaceExtractor
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(VecIsoSurfaceExtractor,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,std::vector<vtkImageData*>);
    //    BBTK_DECLARE_INPUT(InVtkObject,vtkObject *);
    BBTK_DECLARE_INPUT(Isovalue,double);
    BBTK_DECLARE_INPUT(Opacity,double);
    BBTK_DECLARE_INPUT(Colour,std::vector<double>);
    BBTK_DECLARE_INPUT(Renderer,vtkRenderer *);
    BBTK_DECLARE_INPUT(Transform, vtkLinearTransform *);
    BBTK_DECLARE_OUTPUT(Out,std::vector<vtkProp3D*>);
  BBTK_PROCESS(Process);
  void Process();

//	virtual void bbUserConstructor();
//	virtual void bbUserCopyConstructor();
//	virtual void bbUserDestructor();
	void Init();

  std::vector<vtkMarchingCubes*>  VecMarchingcubes;
  std::vector<vtkPolyDataMapper*> VecPolydatamapper;
  std::vector<vtkProp3D*>         VecVtkactor; 

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(VecIsoSurfaceExtractor,bbtk::AtomicBlackBox);
BBTK_NAME("VecIsoSurfaceExtractor");
BBTK_AUTHOR("InfoTeam CREATIS-LRMN");
BBTK_DESCRIPTION("Vector of IsoSurfaceExtractor");
  BBTK_CATEGORY("3D object creator");
  BBTK_INPUT(VecIsoSurfaceExtractor,In,"Input image",std::vector<vtkImageData*>,"");
  //  BBTK_INPUT(IsoSurfaceExtractor,InVtkObject,"Image vtkObject",vtkObject*);
  BBTK_INPUT(VecIsoSurfaceExtractor,Isovalue,"Isovalue",double,"");
  BBTK_INPUT(VecIsoSurfaceExtractor,Opacity,"Opacity",double,"");
  BBTK_INPUT(VecIsoSurfaceExtractor,Colour,"r g b",std::vector<double>,"colour");
  BBTK_INPUT(VecIsoSurfaceExtractor,Renderer,"3D scene in which to insert the surface",vtkRenderer*,"");
  BBTK_INPUT(VecIsoSurfaceExtractor,Transform,"Linear Transform (4x4 homogeneous)",vtkLinearTransform*,"");
  BBTK_OUTPUT(VecIsoSurfaceExtractor,Out,"Extracted iso-surface",std::vector<vtkProp3D*>,"");
BBTK_END_DESCRIBE_BLACK_BOX(VecIsoSurfaceExtractor);
}
// EO namespace bbvtk

#endif // __bbvtkVecIsoSurfaceExtractor_h_INCLUDED__

