/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkVolumeRenderer.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.7 $
=========================================================================*/



/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef _USE_VTK_


#ifndef __bbvtkVolumeRenderer_h_INCLUDED__
#define __bbvtkVolumeRenderer_h_INCLUDED__


#include "bbtkAtomicBlackBox.h"

#include "vtkVersion.h"
#include "vtkImageData.h"
//#include <vtkImageShiftScale.h>
//#include <vtkVolumeRayCastMIPFunction.h>
#include "vtkVolumeProperty.h"
//EED 2018-07-20 Migration VTK8
#if (VTK_MAJOR_VERSION <= 7) 
	#include "vtkVolumeRayCastCompositeFunction.h"
	#include "vtkVolumeRayCastMapper.h"
#else 
	#include <vtkFixedPointVolumeRayCastMapper.h>
#endif
#include "vtkProp3D.h"
#include "vtkVolume.h"

#include "vtkPiecewiseFunction.h"
#include "vtkColorTransferFunction.h"

#include "bbvtk_EXPORT.h"
#include "vtkVolumeProperty.h"

namespace bbvtk
{
  class bbvtk_EXPORT VolumeRenderer : public bbtk::AtomicBlackBox
  { 
  public:
    BBTK_BLACK_BOX_INTERFACE(VolumeRenderer,bbtk::AtomicBlackBox);

    BBTK_DECLARE_INPUT(In,             vtkImageData *);
    BBTK_DECLARE_INPUT(ColorFunction,  vtkPiecewiseFunction*);
    BBTK_DECLARE_INPUT(ColorFunction1, vtkColorTransferFunction *);
    BBTK_DECLARE_INPUT(OpacityFunction,vtkPiecewiseFunction*);
    
    BBTK_DECLARE_OUTPUT(Out, vtkProp3D*);
    BBTK_PROCESS(Process);
    void Process();
    
  protected:

  private:
    vtkVolumeProperty                 *mVolumeProperty;
//EED 2018-07-20 Migration VTK8
#if (VTK_MAJOR_VERSION <= 7) 
    vtkVolumeRayCastCompositeFunction *mRayCastFunction;
    vtkVolumeRayCastMapper            *mMapper;
#else 
    vtkFixedPointVolumeRayCastMapper  *mMapper;
#endif
    vtkVolume                         *mVolume;
    vtkVolumeProperty                 *_volumeProperty;
  };
   
  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(VolumeRenderer,bbtk::AtomicBlackBox);
  BBTK_NAME("VolumeRenderer");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Renders a 3D image. Creates a vtkProp3D object to insert into a 3D scene (e.g. a Viewer3D)");
  BBTK_CATEGORY("3D object creator");
  BBTK_INPUT(VolumeRenderer,ColorFunction,  "Color function",                           vtkPiecewiseFunction*,"");
  BBTK_INPUT(VolumeRenderer,ColorFunction1, "Color function1 instead of Color function",vtkColorTransferFunction*,"");
  BBTK_INPUT(VolumeRenderer,OpacityFunction,"Opacity function",                         vtkPiecewiseFunction*,"");
  BBTK_INPUT(VolumeRenderer,In,             "Input Image",                              vtkImageData *,"");
  
  BBTK_OUTPUT(VolumeRenderer,Out, "3D object to plug into a 3D viewer",vtkProp3D*, "");
  BBTK_END_DESCRIBE_BLACK_BOX(VolumeRenderer);
  //=================================================================


}//namespace bbvtk

#endif  //__bbtvtkVolumeRenderer_h__

#endif //_USE_VTK_

