/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxCheckBox.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.4 $
=========================================================================*/

/* ---------------------------------------------------------------------

* Copyright (c) CREATIS-LRMN (Centre de Recherche en Imagerie Medicale)
* Authors : Eduardo Davila, Laurent Guigues, Jean-Pierre Roux
*
*  This software is governed by the CeCILL-B license under French law and 
*  abiding by the rules of distribution of free software. You can  use, 
*  modify and/ or redistribute the software under the terms of the CeCILL-B 
*  license as circulated by CEA, CNRS and INRIA at the following URL 
*  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
*  or in the file LICENSE.txt.
*
*  As a counterpart to the access to the source code and  rights to copy,
*  modify and redistribute granted by the license, users are provided only
*  with a limited warranty  and the software's author,  the holder of the
*  economic rights,  and the successive licensors  have only  limited
*  liability. 
*
*  The fact that you are presently reading this means that you have had
*  knowledge of the CeCILL-B license and that you accept its terms.
* ------------------------------------------------------------------------ */                                                                         

/**
 * \file 
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
*/

/**
 * \class bbwx::CheckBox
 * \brief 

 * \class bbwx::CheckBoxWidget
 * \brief 
 */

#ifdef _USE_WXWIDGETS_

// Prevents multiple inclusions : use symbols of the form
// __FILENAME_INCLUDED__ 
// where FILENAME must be replaced by the actual file name
#ifndef __bbwxCheckBox_h_INCLUDED__
#define __bbwxCheckBox_h_INCLUDED__

// Include wxBlackBox definition
#include "bbtkWxBlackBox.h"

#include "bbwx_EXPORT.h"


// Namespace of the package "wx" is "bbwx" 
// Namespace associated to packages should be of the form :
// bbPACKAGENAME
namespace bbwx
{
  
  //------------------------------------------------------------------------
  // The black box
  class bbwx_EXPORT CheckBox : public bbtk::WxBlackBox
  {
    
    BBTK_BLACK_BOX_INTERFACE(CheckBox,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(In,bool);
    BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(ReactiveOnKeystroke,int);
    BBTK_DECLARE_OUTPUT(Out,bool);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    void Process();
    void CreateWidget(wxWindow*);

  protected:

  };
  
  //--------------------------------------------------------------------------
  // The widget created by the box 
  class CheckBoxWidget : public wxPanel 
  {
  public:
    /// Ctor with the two first params the parent window and the creator box
    /// which must be passed to the WxBlackBoxWidget constructor.
    /// The other params initialize the widget 
    CheckBoxWidget(CheckBox* box, wxWindow *parent,
		 wxString title,
		 bool value, int reactiveOnKeyStroke
                 );
    /// Dtor
    ~CheckBoxWidget();
    /// Events callbacks
    /// Called when the box is clicked
    void OnCheckBoxClick(wxCommandEvent& event);
    void OnCheckBoxClick_();

    // Accessors
    bool GetValue() { return mwxCheckBox->GetValue(); }
    void SetValue(bool val);
    // Update the texts which display the min/max/current values of the slider
	
  private:
    CheckBox*    mBox;
    wxCheckBox   *mwxCheckBox;
    int          _reactiveOnKeyStroke;
    bool         val;
  };
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //=================================================================
 
  //=================================================================
  // the black box description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(CheckBox,bbtk::WxBlackBox);
  BBTK_NAME("CheckBox");
  BBTK_AUTHOR("jpr@creatis.insa-lyon.fr");
  // Already inserted for any WxBlackBox  BBTK_CATEGORY("widget");
  BBTK_DESCRIPTION("(C++,Python,JavaScript) CheckBox widget");
  BBTK_INPUT(CheckBox, In,   "Initial value of the CheckBox (default false)",bool,       "");
  BBTK_INPUT(CheckBox, Title,"Title shown above the CheckBox (default '') ", std::string,"");
  BBTK_OUTPUT(CheckBox,Out,  "Current value of the CheckBox",                bool,       "");
  BBTK_INPUT(CheckBox,ReactiveOnKeystroke,"(default 1)   0: no event generated when the checkbox is clicked on, 1: event generated when the checkbox is clicked on ", int,"");
  BBTK_END_DESCRIBE_BLACK_BOX(CheckBox);
  //=================================================================
  


} //namespace bbwx

#endif  //__bbtkwxCheckBox_h_INCLUDED__

#endif //_USE_WXWIDGETS_
