/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxFileSelector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.9 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef USE_WXWIDGETS


#ifndef __bbWxFileSelector_h__
#define __bbWxFileSelector_h__

#include "bbtkAtomicBlackBox.h"
#include "bbwx_EXPORT.h"


namespace bbwx
{
  
  
  

  //=================================================================
  class bbwx_EXPORT FileSelector : public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(FileSelector,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(Message,std::string);
    BBTK_DECLARE_INPUT(DefaultDir,std::string);
    BBTK_DECLARE_INPUT(DefaultFile,std::string);
    BBTK_DECLARE_INPUT(Wildcard,std::string);
    BBTK_DECLARE_INPUT(OpenSave,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(Process);
    void Process();

  protected:

  };
  //=================================================================
  
 
  //=================================================================
  // AtomicBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(FileSelector,bbtk::AtomicBlackBox);
  BBTK_NAME("FileSelector");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_CATEGORY("widget, Selector");
  BBTK_DESCRIPTION("Pops up a file selection dialog for reading or saving (wxFileDialog)");
  BBTK_INPUT(FileSelector,Title,"Title of the dialog",std::string,"");
  BBTK_INPUT(FileSelector,Message,"Message to show on the dialog",std::string,"");
  BBTK_INPUT(FileSelector,DefaultDir,"The default directory",std::string,"");
  BBTK_INPUT(FileSelector,DefaultFile,"The default filename",std::string,"file name");
  BBTK_INPUT(FileSelector,Wildcard,"A wildcard, such as \"*.*\" or \"BMP files (*.bmp)|*.bmp|GIF files (*.gif)|*.gif\"",std::string,"wildcard");
  BBTK_INPUT(FileSelector,OpenSave,"Open for an open dialog (default) / Save for a save dialog",std::string,"");
  BBTK_OUTPUT(FileSelector,Out,"The file selected by the user",std::string,"file name");
  BBTK_END_DESCRIBE_BLACK_BOX(FileSelector);
  //=================================================================



}



//namespace bbtk
#endif  //__bbtkWxFileSelector_h__

#endif //USE_WXWIDGETS
