/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxInputText.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.11 $
=========================================================================*/

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */

#ifdef _USE_WXWIDGETS_


#ifndef __bbWxInputText_h__
#define __bbWxInputText_h__

#include "bbtkWxBlackBox.h"

#include "bbwx_EXPORT.h"

namespace bbwx
{

  //=================================================================
  class bbwx_EXPORT InputText : public bbtk::WxBlackBox
  {
    
    BBTK_BLACK_BOX_INTERFACE(InputText,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(In,std::string);
    BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(ReactiveOnKeystroke,int);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(Process);
    void Process();
    BBTK_CREATE_WIDGET(CreateWidget);
    void CreateWidget(wxWindow*);
    
  private:
	  bool firsttime;
  protected:

  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(InputText,bbtk::WxBlackBox);
  BBTK_NAME("InputText");
  BBTK_AUTHOR("laurent guigues at creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("(C++,Python) A zone in which the user can enter a text (wxTextCtrl)");
  BBTK_INPUT(InputText,In,"Initial text (default '')",std::string,"");
  BBTK_INPUT(InputText,Title,"Title of the input zone (default '') ", std::string,"");
  BBTK_INPUT(InputText,ReactiveOnKeystroke,"0 not event generated, 1 Enter event genereated, 2 All keys, (default '2') ", int,"");
  BBTK_OUTPUT(InputText,Out,"Current text",std::string,"");
  BBTK_END_DESCRIBE_BLACK_BOX(InputText);
 
  //=================================================================

}



//namespace bbtk
#endif  //__bbWxInputText_h__

#endif //USE_WXWIDGETS
