/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbwxvtkViewer3D.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:36 $
  Version:   $Revision: 1.15 $
 
=========================================================================*//**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef _USE_WXWIDGETS_
#ifdef _USE_VTK_


#ifndef __bbWxViewer3D_h__
#define __bbWxViewer3D_h__

#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkInteractorStyleTrackballCamera.h>

#include "bbtkWxBlackBox.h"
#include "creawxVTKRenderWindowInteractor.h"




namespace bbwxvtk
{
  class Viewer3D; 
  //--------------------------------------------------------------------------
  class Viewer3DWidget : public wxPanel
  {
  public:
    Viewer3DWidget(Viewer3D* box, wxWindow *parent, bool stereo);
    ~Viewer3DWidget();

    void Update();
    vtkRenderer *GetRenderer();
    crea::wxVTKRenderWindowInteractor * GetInteractor();
    virtual void Refresh(bool eraseBackground = true, const wxRect* rect = NULL);

  private:
    Viewer3D							*mBox;
    vtkRenderer                  		*renderer;
    vtkRenderWindow              		*renderwindow;
    vtkInteractorStyleTrackballCamera 	*interactorstyle;
    crea::wxVTKRenderWindowInteractor  	*wxvtkrenderwindowinteractor;
  };
  
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  
  class /*BBTK_EXPORT*/ Viewer3D : public bbtk::WxBlackBox
  {    
    BBTK_BLACK_BOX_INTERFACE(Viewer3D,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(In1, vtkProp3D *);
    BBTK_DECLARE_INPUT(In2, vtkProp3D *);
    BBTK_DECLARE_INPUT(In3, vtkProp3D *);
    BBTK_DECLARE_INPUT(In4, vtkProp3D *);
    BBTK_DECLARE_INPUT(In5, vtkProp3D *);
    BBTK_DECLARE_INPUT(Obs1, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs2, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs3, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs4, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs5, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Stereo, bool);
    BBTK_DECLARE_INPUT(BackgroundColor,std::vector<double>);
    BBTK_DECLARE_OUTPUT(Renderer,vtkRenderer*);
    BBTK_DECLARE_OUTPUT(Interactor,crea::wxVTKRenderWindowInteractor*);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    BBTK_ON_SHOW_WIDGET(OnShowWidget);
  
    void Process();
    void CreateWidget(wxWindow*);
    void OnShowWidget();

    void DisableObservers();

  protected:
    bool firsttime;
  };
   
  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(Viewer3D,bbtk::WxBlackBox);
  BBTK_NAME("Viewer3D");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("3D Viewer widget (vtk)");
  BBTK_CATEGORY("viewer");
  BBTK_INPUT(Viewer3D,BackgroundColor,"Render background's color",std::vector<double>,"");
  BBTK_INPUT(Viewer3D,In1,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(Viewer3D,In2,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(Viewer3D,In3,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(Viewer3D,In4,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(Viewer3D,In5,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(Viewer3D,Obs1,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(Viewer3D,Obs2,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(Viewer3D,Obs3,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(Viewer3D,Obs4,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(Viewer3D,Obs5,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(Viewer3D,Stereo,"Stereo with Red-Blue filter.  False/True  (default False)",bool,"");
  BBTK_OUTPUT(Viewer3D,Renderer,"Renderer to which actors can be added.",vtkRenderer*,"");
  BBTK_OUTPUT(Viewer3D,Interactor,"Interactor with which vtk widgets can interact",crea::wxVTKRenderWindowInteractor*,"");
  BBTK_END_DESCRIBE_BLACK_BOX(Viewer3D);
  //=================================================================


}//namespace bbtk

#endif  //__bbtkWxViewer3D_h__

#endif //_USE_VTK_
#endif //_USE_WXWIDGETS_
 
