/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 

/*=========================================================================
                                                                                
  Program:   crea
  Module:    $RCSfile: creaConfigure.h.in,v $
  Language:  C++
  Date:      $Date: 2012/11/15 10:43:26 $
  Version:   $Revision: 1.4 $
                                                                                
                                                                                
     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.
                                                                                
=========================================================================*/

#ifndef __creaConfigure_h
#define __creaConfigure_h

/* This header is configured by CREA's build process.  */

/*--------------------------------------------------------------------------*/
/* Platform Features                                                        */

/* Byte order.  */
/* #undef CREA_WORDS_BIGENDIAN */

/* Allow access to UINT32_MAX , cf creaCommon.h */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS
#endif

/* Hardcode the path to CREA_DATA_ROOT */
#ifndef CREA_DATA_ROOT
#define CREA_DATA_ROOT ""
#endif 

/* Usefull in particular for loadshared where the full path
 * to the lib is needed */
#define CREA_EXECUTABLE_OUTPUT_PATH "/Users/davila/Creatis/C23/creatools_bin/creaBin"
#define CREA_LIBRARY_OUTPUT_PATH    "/Users/davila/Creatis/C23/creatools_bin/creaBin"
#define CREA_DATA_PATH    ""

/* For older gcc / broken plateform */
/* #undef CREA_NO_ANSI_STRING_STREAM */

/* I guess something important */
#define CMAKE_HAVE_STDINT_H
#define CMAKE_HAVE_INTTYPES_H
#define CMAKE_HAVE_TERMIOS_H
 
/* This variable allows you to have helpful debug statement */
/* That are in between #ifdef / endif in the crea code */
/* That means if CREA_DEBUG is OFF there shouldn't be any 'cout' at all ! */
/* only cerr, for instance 'invalid file' will be allowed */
/* #undef CREA_DEBUG */

/* Whether we are building shared libraries.  */
/* This was important as long as CREA is LGPL */
/* #undef BUILD_SHARED_LIBS */

/* CREA uses __FUNCTION__ which is not ANSI C, but C99 */
/* #undef CREA_COMPILER_HAS_FUNCTION */

#define CREA_SIZEOF_LONG 

/* Special time structure support */
#define CMAKE_HAVE_SYS_TIMES_H
#define CMAKE_HAVE_SYS_TIMEB_H

/* GetMacAddress require a lot of include file to access low level API */
/* #undef CMAKE_HAVE_UNISTD_H */
/* #undef CMAKE_HAVE_STDLIB_H */
/* #undef CMAKE_HAVE_SYS_IOCTL_H */
/* #undef CMAKE_HAVE_SYS_SOCKET_H */
/* #undef CMAKE_HAVE_SYS_SOCKIO_H */
/* #undef CMAKE_HAVE_NET_IF_H */
/* #undef CMAKE_HAVE_NETINET_IN_H */
/* #undef CMAKE_HAVE_NET_IF_DL_H */
/* #undef CMAKE_HAVE_NET_IF_ARP_H */
/* #undef HAVE_SA_LEN */

/*--------------------------------------------------------------------------*/
/* CREA Versioning                                                          */

/* Version number.  */
#ifndef CREA_VERSION
#define CREA_MAJOR_VERSION 
#define CREA_MINOR_VERSION 
#define CREA_BUILD_VERSION 
#define CREA_VERSION ""
#endif

#endif
