/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ 
*/                                                                         


#ifndef __creaVtk_MACROS_h_INCLUDED__
#define __creaVtk_MACROS_h_INCLUDED__

#ifdef USE_VTK

#include <vtkVersionMacros.h>

namespace crea
{

#define DEF_POINTER_IMAGE_VTK_CREA_difinition(VALUE,SCALARSIZE,POINTERIMAGE,SCALARTYPE)						\
	double 	VALUE			;																				\
	int 	SCALARSIZE 		;																				\
	char 	*POINTERIMAGE 	;																				\
	int		SCALARTYPE		;				

#define DEF_POINTER_IMAGE_VTK_CREA_set(VALUE,SCALARSIZE,POINTERIMAGE,SCALARTYPE,VTKIMAGE)					\
			VALUE			= 0;																			\
			SCALARSIZE 		= VTKIMAGE->GetScalarSize();													\
			POINTERIMAGE 	= (char*)(VTKIMAGE->GetScalarPointer());										\
			SCALARTYPE		= VTKIMAGE->GetScalarType();				


#define DEF_POINTER_IMAGE_VTK_CREA(VALUE,SCALARSIZE,POINTERIMAGE,SCALARTYPE,VTKIMAGE)						\
	double 	VALUE			= 0;																			\
	int 	SCALARSIZE 		= VTKIMAGE->GetScalarSize();													\
	char 	*POINTERIMAGE 	= (char*)(VTKIMAGE->GetScalarPointer());										\
	int		SCALARTYPE		= VTKIMAGE->GetScalarType();				


#define GETVALUE_VTK_CREA(VALUE,POINTER,SCALARTYPE) 														\
	if 		(SCALARTYPE==VTK_DOUBLE) 		{ VALUE=(double)*((double*)POINTER); 		            }		\
	else if (SCALARTYPE==VTK_FLOAT) 	 	{ VALUE=(double)*((float*)POINTER);			            }		\
	else if (SCALARTYPE==VTK_CHAR) 			{ VALUE=(double)*((char*)POINTER);			            }		\
    else if (SCALARTYPE==VTK_SIGNED_CHAR)   { VALUE=(double)*((char*)POINTER);                      }       \
	else if (SCALARTYPE==VTK_UNSIGNED_CHAR) { VALUE=(double)*((unsigned char*)POINTER);	            }		\
	else if (SCALARTYPE==VTK_INT) 			{ VALUE=(double)*((int*)POINTER);			            }		\
	else if (SCALARTYPE==VTK_UNSIGNED_INT) 	{ VALUE=(double)*((unsigned int*)POINTER);	            }		\
	else if (SCALARTYPE==VTK_LONG) 			{ VALUE=(double)*((long*)POINTER);			            }		\
	else if (SCALARTYPE==VTK_UNSIGNED_LONG) { VALUE=(double)*((unsigned long*)POINTER);	            }		\
	else if (SCALARTYPE==VTK_SHORT) 		{ VALUE=(double)*((short*)POINTER);			            }		\
	else if (SCALARTYPE==VTK_UNSIGNED_SHORT){ VALUE=(double)*((unsigned short*)POINTER);            }  		\
	else { printf("EED Error!  creaVtk_MACROS.h  GETVALUE_VTK_CREA   SCALARTYPE=%d \n",SCALARTYPE); }

#define GETVALUE2_VTK_CREA(VALUE,POINTER,SCALARTYPE,INDEX) 													\
	if 		(SCALARTYPE==VTK_DOUBLE) 		{ VALUE=(double)((double*)POINTER)[INDEX]; 			    }		\
	else if (SCALARTYPE==VTK_FLOAT) 	 	{ VALUE=(double)((float*)POINTER)[INDEX];			    }		\
	else if (SCALARTYPE==VTK_CHAR) 			{ VALUE=(double)((char*)POINTER)[INDEX];			    }		\
    else if (SCALARTYPE==VTK_SIGNED_CHAR)   { VALUE=(double)((char*)POINTER)[INDEX];                }       \
	else if (SCALARTYPE==VTK_UNSIGNED_CHAR) { VALUE=(double)((unsigned char*)POINTER)[INDEX];	    }		\
	else if (SCALARTYPE==VTK_INT) 			{ VALUE=(double)((int*)POINTER)[INDEX];				    }		\
	else if (SCALARTYPE==VTK_UNSIGNED_INT) 	{ VALUE=(double)((unsigned int*)POINTER)[INDEX];	    }		\
	else if (SCALARTYPE==VTK_LONG) 			{ VALUE=(double)((long*)POINTER)[INDEX];		    	}		\
	else if (SCALARTYPE==VTK_UNSIGNED_LONG) { VALUE=(double)((unsigned long*)POINTER)[INDEX];	    }		\
	else if (SCALARTYPE==VTK_SHORT) 		{ VALUE=(double)((short*)POINTER)[INDEX];			    }		\
	else if (SCALARTYPE==VTK_UNSIGNED_SHORT){ VALUE=(double)((unsigned short*)POINTER)[INDEX];	    }		\
	else { printf("EED Error!  creaVtk_MACROS.h  GETVALUE2_VTK_CREA   SCALARTYPE=%d \n",SCALARTYPE);}

#define SETVALUE2_VTK_CREA(VALUE,POINTER,SCALARTYPE,INDEX) 													\
	if 		(SCALARTYPE==VTK_DOUBLE) 		{ ((double*)POINTER)[INDEX]			= (double)VALUE; 		}	\
	else if (SCALARTYPE==VTK_FLOAT) 	 	{ ((float*)POINTER)[INDEX]			= (float)VALUE;			}	\
	else if (SCALARTYPE==VTK_CHAR) 			{ ((char*)POINTER)[INDEX]			= (char)VALUE;			}	\
    else if (SCALARTYPE==VTK_SIGNED_CHAR)   { ((char*)POINTER)[INDEX]           = (char)VALUE;          }   \
	else if (SCALARTYPE==VTK_UNSIGNED_CHAR) { ((unsigned char*)POINTER)[INDEX]	= (unsigned char)VALUE;	}	\
	else if (SCALARTYPE==VTK_INT) 			{ ((int*)POINTER)[INDEX]			= (int)VALUE;			}	\
	else if (SCALARTYPE==VTK_UNSIGNED_INT) 	{ ((unsigned int*)POINTER)[INDEX]	= (unsigned int)VALUE;	}	\
	else if (SCALARTYPE==VTK_LONG) 			{ ((long*)POINTER)[INDEX]			= (long)VALUE;			}	\
	else if (SCALARTYPE==VTK_UNSIGNED_LONG) { ((unsigned long*)POINTER)[INDEX]	= (unsigned long)VALUE;	}	\
	else if (SCALARTYPE==VTK_SHORT) 		{ ((short*)POINTER)[INDEX]			= (short)VALUE;			}	\
	else if (SCALARTYPE==VTK_UNSIGNED_SHORT){ ((unsigned short*)POINTER)[INDEX] = (unsigned short)VALUE;}	\
	else { printf("EED Error!  creaVtk_MACROS.h   SETVALUE2_VTK_CREA   SCALARTYPE=%d \n",SCALARTYPE);   }

}


#endif // USE_VTK
#endif // __creaVtk_MACROS_h_INCLUDED__



