/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
//
// C++ Interface: brukerdataset
//
// Description: 
//
//
// Author:  <Denis Grenier>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BRUKERDATASET_H
#define BRUKERDATASET_H

/*! \file brukerdataset.h
*/
#include <cstdlib>
#include <stdlib.h>
#include <string>
#include <iostream>
#include <sstream>
#include <stdio.h>
#include <fstream>
#include <map>
#include <algorithm>
#include "boost/regex.hpp"

#include "brukerSystem.h"
#include "brukerFieldData.h"
#include "brukerobjectvaryingproperties.h"

    const boost::regex KeyWord("^##\\$?([^[:cntrl:]]+)=.*");
    const boost::regex UnsignedInteger("([0-9]+)");
    const boost::regex SignedInteger("(\\-?[0-9]+)");
    const boost::regex Float("([\\-\\+eE0-9\\.]+)");
    const boost::regex IntOrFloat("([\\-\\+eE0-9\\.]+)");
    const boost::regex Dimensionnality("=\\( ([^[:cntrl:]]+) \\)");
    const boost::regex BufferNValues("^##\\$?[^[:cntrl:]]+=\\( [^[:cntrl:]]+ \\)[[:space:]]*[[:cntrl:]]*([^[.dollar-sign.]]+).*");
    const boost::regex Buffer1Value("^##\\$?[^[:cntrl:]]+=(.*)");
    const boost::regex IntSeries("([\\-0-9]*[[:space:]]*[[:cntrl:]]*)+");
    const boost::regex FloatSeries("([\\-\\+eE0-9\\.]+[[:space:]]*[[:cntrl:]]*)+");


/*! \class  BrukerDataSet
\brief This class purpose is to extract information from a bruker experiment and setup the extracted information for an easy use
*/

class /*creaBruker_EXPORT*/ BrukerDataSet
{
friend class BrukerKspaceObject;
    typedef std::map<std::string, BrukerFieldData> BrukMapType;
    //typedef BrukMapType::iterator iterator;
    //typedef BrukMapType::const_iterator const_iterator;
public:
	BrukerDataSet();
	~BrukerDataSet();
	bool LoadFile(std::string FileToRead);
	bool FillMap();
	void PrintKey(std::string &);
	void PrintSelf();
	bool                   Getkspace (std::string &);
	const BrukerFieldData& GetFieldData(std::string &);
	const BrukerFieldData& GetFieldData(const char *);
	bool                   SetLoopStructure ( int dimension);
	bool                   SetLoopStructureOld ( );
	bool                   SetLoopStructure (const std::vector<int >& theValue);
	std::vector<int >      GetLoopStructure ( ) const;
	bool                   SetBrukerObjectsLineList( );
	bool                   SetBrukerImageList ( );
	
	std::vector<std::vector <int > >        GetBrukerObjectsLineList() const;
	std::vector<std::vector <int > >        GetBrukerImageList() const;
	std::map<std::string, BrukerFieldData > GetBrukerHeaderMap() const;

	bool              SetInnerObjectLoopStructure (int dimension);
	std::vector<int > GetInnerObjectLoopStructure() const;
	bool              SetOuterObjectLoopStructure (int dimension);
	std::vector<int > GetOuterObjectLoopStructure() const;
	bool              SetImageLoopStructure ();
	std::vector<int > GetImageLoopStructure() const;
		
	BrukerObjectVaryingProperties ObjectVaryingProperties;
private:

    std::string GetKeyword                (std::string &kw);
    std::string SearchBufferForText       (std::string &kw, const boost::regex& RegExp);
    bool        BoolMatchBufferForText    (std::string &kw, const boost::regex& RegExp);
    std::string MatchBufferForText        (std::string &kw, const boost::regex& RegExp);
    int         GetDimensionnality        (std::string &kw);
    int         GetIntValueOfDimN         (std::string &kw, int n);
    int         GetIntValueN              (std::string &kw, int n);
    std::string GetContentType            (std::string &kw);
    std::string GetValuesPart             (std::string &kw);
    double      GetDoubleValueN           (std::string &kw, int n);
    int         GetKeywordNumberOfElements(std::string &kw);
    std::string GetTextValueN             (std::string &kw, int n);
    bool        CheckExistKeyword         (std::string &kw);
    bool        CheckExistKeyword         (const char *kw);
    std::string RemoveNewlines(std::string);
    std::string RemoveSpaces(std::string);
    
    //BrukMapType 

    std::map<std::string, BrukerFieldData> BrukerHeaderMap;
    std::string                     WholeHeader;
    std::vector<double>             WholeKspace;    
    std::vector<int>                LoopStructure;
    std::vector<int>                InnerObjectLoopStructure;
    std::vector<int>                OuterObjectLoopStructure;
    std::vector<int>                ImageLoopStructure;
    std::vector <std::vector<int> > BrukerObjectsLineList;
    std::vector <std::vector<int> > BrukerImageList;

protected:
};

#endif
