/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/

//
// C++ Interface: brukerimage
//
// Description: 
//
//
// Author: Denis Grenier, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BRUKERIMAGE_H
#define BRUKERIMAGE_H

#include "brukerdataset.h"
#include "brukerSystem.h"
/**
This class centralizes the informations "needed" to exploit a bruker image file 2dseq

	@author Denis Grenier
	@file brukerimage.h
*/
class /*creaBruker_EXPORT*/ BrukerImage
{
public:
   BrukerImage(BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco);
   ~BrukerImage();

   bool Init(BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	
   int                  getAbsoluteTimePosition()   const;
   double               getRelativeTimePosition()   const;
   const std::vector <int>    &getFOVpixels()       const;
   const std::vector <double> &getFOVcm()           const;
   double               getSliceThickness()         const;
   double               getTE()                     const;
   double               getTR()                     const;
   double               getTI()                     const;
   double               getFlipAngle()              const;
   int                  getNA()                     const;
   int                  getNR()                     const;
   int                  getDS()                     const;
   int                  getNAE()                    const;
   int                  getACQ_phase_factor()       const;
   std::string          getWordType()               const;
   std::string          getImageType()              const;
   const std::string   &getDataEndianness()         const;
   size_t               getImageByteSize()          const;
   size_t               getBeginingOfImageInBytes() const;
   
   const std::vector <int>    &getLoopStamp() const;

   const std::vector<std::vector <double> >  &getRotationMatrixRPS2XYZ()    const;
   const std::vector <double>                &getTranslationVectorRPS2XYZ() const;
	
	
protected:

private:

// on devrait plutot les nommer 'computeXXX' (setXXX est d'habitude reserve aux accesseurs 'publics')

	bool setAbsoluteTimePosition    (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setRelativeTimePosition    (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setFOVpixels               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setFOVcm                   (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setSliceThickness          (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTE                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTR                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTI                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setFlipAngle               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setLoopStamp               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setNA                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setNR                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setNAE                     (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setDS                      (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setACQ_phase_factor        (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setRotationMatrixRPS2XYZ   (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setTranslationVectorRPS2XYZ(BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setWordType                (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setImageType               (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setDataEndianness          (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setImageByteSize           (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);
	bool setBeginingOfImageInBytes  (BrukerDataSet &TheOrigAcqp, BrukerDataSet &TheOrigReco, int TheValue);

        std::vector<int>    FOVpixels;
        std::vector<double> FOVcm;
        std::vector<int>    LoopStamp;
        double SliceThickness;
        double TE;
        double TR;
        double TI;
        double FlipAngle;
        double RelativeTimePosition;
        int NA;
        int NR;
        int NAE;
        int DS;
        int ACQ_phase_factor;
        std::vector<std::vector<double> >  RotationMatrixRPS2XYZ;
        std::vector<double>                TranslationVectorRPS2XYZ;
        int  AbsoluteTimePosition;
        std::string WordType;
        std::string ImageType;
        std::string DataEndianness;
        size_t ImageByteSize;
        size_t BeginingOfImageInBytes;

};

#endif
