/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __KERNELMANAGERCONTOUR__
#define __KERNELMANAGERCONTOUR__



//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
//#include "ImageSourceThing.h"
//#include "ImageSectionThing.h"
//#include "AxeThing.h"
//#include "ContourThing.h"
#include "OutlineModelManager.h"
#include "OutlineModelBuilder.h"
#include "time.h"
#ifdef ParserOsirix_BUILD
#include "OsirixParser.h"
#endif
#include "ContourPropagation.h"

#include "manualContourModel.h"
#include "manualContourModelCircle.h"
#include "manualContourModelLine.h"
#include "manualContourModelRoi.h"
#include "manualContourModelPolygon.h"

#include <vtkImageChangeInformation.h>

class KernelManagerContour{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:
	/**
	** With this constructor the setVectImages and initialize environment must be called
	**/
	KernelManagerContour();
	/**
	**	If images are available before the construction of the kernelManager this method should be used
	**	it sets the vector images and initializes the environment
	**/
	KernelManagerContour(std::vector<vtkImageData*> images,std::string datadir,std::string tmpdir);
	~KernelManagerContour();
	std::vector<vtkImageData*> getVectImages();
    void changeImage(int id, vtkImageData *img);
    void setVectImages(std::vector<vtkImageData*> vectimg);
	void GetSpacing(double *vecspc, int iImage);
	/**
	**	This method returns the source of the image data selected by the user.
	*/
	vtkImageData* getSourceImage();
	void initializeEnvironment(std::string datadir);
	/**
	**	This methods connect the event in the class interfNewContourMenu with the world of the appli
	**/
	std::string createOutline(manualBaseModel * manModelContour,std::vector<int> instantVector);
	/////////////////////////////////
	std::string intToString(int num);
	std::vector<std::string> GetLstNameThingsStatic();
	void SaveThingName(FILE* pFile, FILE *pFileData, std::string name );
	std::vector<std::string> GetLstNameThings();
	bool IsPartOfStaticList(std::string keyName );
	void deleteCModel(std::string theKeyName);
	void removeAllOutlines();
	//void setInstance(theInstant);
	std::vector<NameWrapper *> getActualInstantOutlines();
	int getNamesWrappingSize();
	std::string getNameWrapping(int i);
	void setInstant(Instant* theInstant);
	void setInstant(std::vector<int> vectInstant);
	std::string createCopyContourOf ( std::string anExistingKName, std::vector<int> &instantNoTouchData);
	Instant * getCurrentInstant();
	manualBaseModel* getOutlineByKeyName(std::string cloneName);
	bool onRedo(std::string& filename);
	bool onUndo(std::string& filename);
	bool onUndoSaveFile(std::string& filename);
	std::string saveState();
	void changeContourOfManager(std::string keyName, Instant *instant);
	void resetAppend();
	std::string onSpreadAdd( std::vector<double> *vecX, std::vector<double> *vecY, std::vector<double> *vecZ, std::vector<int> instants);
	void getMaxMinZ(double *minZ,double *maxZ);
	manualBaseModel* GetPoints(int z,int type, std::vector<double>* vecCtrlPointX,std::vector<double>* vecCtrlPointY,std::vector<double>* vecCtrlPointZ, std::string& theName,int typeofcontour, std::vector<int> tempVector);
	//
	// Method which creates the model associated with the type in parameter. The possible contour types are:
	// 0-spline
	// 1-spline
	// 2-rectangle
	// 3-circle
	// 4-BullEye
	// 5-BullEyeSector
	// 6-Line
	// 7-Points
	// NOTE: The view and the controler are created in the wxVtkBaseView_SceneManager class, configureViewControlTo method
	// @param typeContour - int
	// @return manualBaseModel - Model created based on the type
	manualBaseModel* factoryManualContourModel(int typeContour);
	void CalculeSplinePropagation();
	std::vector<std::string> getOutlinesNameAtInstant(std::vector<int> tempvector);
	std::vector<ContourThing**> getOutlinesAtInstant(Instant* instant );
	std::vector<manualBaseModel*> ExploseEachModel( std::vector<manualBaseModel*> lstManConMod );
	void getConceptsInformation(std::vector<std::string>& conceptNameVect, std::vector<int>& conceptSizeVect);
	vtkImageData* getImageAtInstant(std::vector<int> inst);

//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

	void setCurrentFileName(std::string filenam);
	std::string getCurrentFileName();
	std::string parseOsirixFile(std::string filename);
private:
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------
	std::vector<vtkImageData*>				vectimages;
	std::vector<std::vector<double> >		vectimagesSpacing;
	ImageSourceThing						*imageSource;
	//Instant * _actualInstant;
//Temporary attribute should be removed
	OutlineModelManager						*modelManager;
	std::string								filename;
	int										inredo;
	int										inundo;
	int										_currentIndex;
	std::string								stundoredo;
	std::string								_datadir;
	ContourPropagation						*_contourPropagation;
	OutlineModelManager						*getOutlineModelManager();
};
#endif
