/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __PanelBullEyeOptions_h_INCLUDED_H__
#define __PanelBullEyeOptions_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/grid.h>

#include <sstream>
//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include "wxContourMainFrame.h"
#include <wx/spinctrl.h>



class  PanelBullEyeOptions : public wxPanel {
public:
	PanelBullEyeOptions(wxWindow* parent, wxSize size);
	~PanelBullEyeOptions ();
	void onRefreshPanel( wxCommandEvent& event );
	int GetNumberOfCrowns();
	int GetNumberOfSections(int nCrown);
	int GetRadioOfCrown(int nCrown);
	double GetAngOfCrownSection(int nCrown,int section);
	double GetAngDeltaOfCrownSection(int nCrown);
protected:

private:
	int							_maxLevels;
	int							_maxSections;
	wxRadioBox					*_radioboxBullEyeGenOpt;
	wxSpinCtrl					*_spinctrlBullEyeNumOfCrowns;
	wxSpinCtrl					*_spinctrlBullEyeNumOfSec;
	wxSlider					*_sliderBullEyeAngle;
	std::vector<wxSpinCtrl *>	_lstBullEyeDetailNumOfSec;
	std::vector<wxSlider *>		_lstBullEyeDetailRadio;
	std::vector<wxSlider *>		_lstBullEyeDetailAngle;


	

	void RefreshPanel();
};


#endif // __wxContourEventHandler_HEADER_FILE__
