/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __interfMainPanel_h_INCLUDED_H__
#define __interfMainPanel_h_INCLUDED_H__

#pragma once

#include <wx/wx.h>
//#include "wxContourEventHandler.h"

#include "interfNewContourMenu.h"
#include "interfIOMenu.h"
#include "interfEditMenu.h"
#include "interfDeleteMenu.h"
#include "interfToolsMenu.h"
#include "interfToolsSpreadPanel.h"
#include "interfSegmentationMenu.h"
#include "interfMenuBar.h"
#include "interfToolsPanels.h"
#include "interfSegmentationPanels.h"
#include "interfImageToolsMenu.h"

#include <wx/treebook.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/splitter.h>
#include <wx/statline.h>

#include "vtkImageData.h"

class interfMainPanel : public wxPanel {

public:

	interfMainPanel(wxWindow * parent, int sizex, int sizey, wxEvtHandler * evtHandler, std::string datadir = "data/Icons");
	~interfMainPanel(void);

	/**	This method should be called the first time by the parent class
	**	in creates all the panels the first time
	**/
	static interfMainPanel* getInstance(wxWindow* parent, std::string datadir, wxEvtHandler * evtHandler=NULL );
	/**	This method should be called the first time by the parent class
	**	in creates all the panels the first time
	**/
	static interfMainPanel* getInstance(wxWindow* parent, wxEvtHandler * evtHandler=NULL);
	/**
	**	Gets the instance of the class
	**/
	static interfMainPanel* getInstance();
	/**
	**	Ressts the instance of the class
	**/
	static void resetInstance();

	/**
	**	Adds a new checkbox to the scrolledwindow using the checkboxsizer
	**	@Params id of contour
	**
	**/
	void addContourCheckBox(std::string id);

	/**
	**	Removes a checkbox from the list of checkboxes in the flexsizer (checkboxsizer)
	**	@Params id of contour
	**
	**/
	void removeContourCheckBox(std::string id);


	/**
	**	Responds to the events of the buttons, when the same panel is responsible for it. It gets the name
	**	of the button corresponding to the method that has to be executed,
	**	it uses attribute eventHandler to call the methods define by the application.
	**	see setEventHandler(wxEventHandler*)
	**/
	void onActionButtonPressed1( wxCommandEvent& event );

	/**
	**	Shows the panel in the
	**/
	void showPanel(wxWindow* panel);

	/**
	**	Hides the panel in the
	**/
	void hidePanel( );

	/**
	**	Gets the Information panel
	**/
	wxPanel* getInfoPanel();

	/**
	**	This methods connect the event in the class interfNewContourMenu with the world of the appli
	**/
	void onCreateContourSpline( );
	void onCreateContourRectangle( );
	void onCreateContourCircle( );
	void onCreateContourLine( );
	// RaC 09-09 ---------------------
	void onCreateContourPoints( );
	// RaC 09-09 ---------------------

	// RaC 10-09 ---------------------
	void onCreateContourPolygon( );
	// RaC 10-09 ---------------------

	void onCreateContoursBullEye(wxPanel* panBull);
	/////////////////////////////////
	void onDeleteContoursActSlice();
	void onDeleteContour();
	void onDeleteAllContours();
	/////////////////////////
	void onCopy();
	void onPaste();
	void onUndo();
	void onRedo();

	//////////////////////////
	void onLoad();
	void onSave();
	void onImport();
	void onTest();
/////////////////////////////7
	void RefreshInterface();
	vtkImageData* getImageData();
	void getImageRange(double[2]);
	void onSegmentationOneSlice(int isovalue,int sampling,int method);
	void onSegmentationOneSliceITK(wxString distance, wxString sigma, wxString alfa, wxString beta, wxString propagation, wxString iterations, wxString inflation);
	int GetImageDataSizeZ();
	void onSegmentationAllSlices(int minZ,int maxZ,int isovalue,int sampling,int method);
	void onMirrorPressed();
	void onMirror();
	void onMirrorAxisShow();
	void onMirrorAxisHide();
	void onMirrorChangeWidth(int width);
	void onThresholdPressed();
	void onColorLayerImagePressed();
	void setLabelSegmentationPanelVTK(wxString tmpString);
	void onSegmentationPressed();
	void onSegmentationPressedITK();
	void onRigidPressed();
	void onWidthOfContour(double width);
	int getColorWindow();
	int getWindowLevel();
	void onBrigthnessColorWindowLevel(int colorwindow,int windowlevel);
	void onInterpolation(bool interpolate);
	void onShowTextContour(bool show);
	void onBeforAfterContour(bool before, bool after);
	void onJumpSlice(int step,int shift);
	void onSpreadPressed();
	void onConfigurationPressed();
	void resetAppend();
	void onSpreadAdd();
	void onSpreadAddAll();
	void appendStringSpread(std::string val);
	void onSpreadGo(int type);
	void setStringSpread(std::string stringtemp);
	void onInformationPressed();
	void getInstantVector(std::vector<int>& tempVector);
	std::vector<std::string> getOutlinesName(int slide);
	void onInformationContourLabels(int typeContourGroup,int selection,int minZ,int maxZ,int grayRangeMin,int grayRangeMax);
	void setStringInfoPanel(wxString tmpString);
	void setRowLabelInfoPanel(int z, wxString tempString);
	int getNumberColsInformationPanel();
	void appendColsInformationPanel(int _numberOfVariablesStatistics);
	void setCellValueInfoPanel(int z,int tmpIntA,wxString tempString);
	void setColLableInfoPanel(int tmpIntB ,wxString tmpTitleString);
	void SetScalarRange(int grayRangeMin,int grayRangeMax);
	void onSaveResults(std::string directory,std::string namefile, std::string filename,
		int typeContourGroup, int selection, int minZ, int maxZ, bool XYZValues, bool contourImage, bool statistics);
	wxString getCellValue(int j,int i);
	void onSnakePressed();
	virtual bool Show(bool show);
	void ShowResultImages(int typeContourGroup, int selection, int minZ, int maxZ);
	void SetContourGroup(int contourGroup);
	void onFlipContours();
	void FlipContours(int typeContourFlip, int flipDirection);

	
//CMRU 29-08-09-----------------------------------------------------------------------------------------------

	/**
	* Associates the current selected contour with a label
	*/
	void onPrintLabel();

	/**
	* Calculates the pixel value in milimeters according to the current contour if the selected contour is a Line Contour
	* @param size Size in milimeters of the selected contour
	* @param unit Measurement unit
	*/
	void onCalibration(wxString size, int unit);

	/**
	* Calculate the pixel value in milimeters
	* @param realSize Size of the contour in milimeters
	* @param sizePixel Size of the contour in pixels
	*/
	double onePixelSize (double realSize,double sizePixel);

	/**
	* Returns the value of a pixel in milimeters
	*/
	double GetPixelValue();
//------------------------------------------------------------------------------------------------------------

private:


	static interfMainPanel* interfmainpanel;


	static wxFrame* _newframe;
	wxPanel* menubar;
	wxPanel* menubar1;
	wxPanel* menubar2;
	wxPanel* menubar3;
	wxPanel* menubar4;
	wxPanel* menubar5;
	wxPanel* menubar6;

	wxWindow* currentWindow;
	wxSplitterWindow* splitterwindow;

	wxPanel* infoPanel;
	wxPanel* infoPanelMask;

//CMRU 17-08-09 ------------------------------------------------------------------

	/**
	* Panel with the calibration options
	*/
	wxPanel* infoPanelCalibration;

	/**
	* Panel who contains the calibration panel and the information panel mask
	*/
	wxPanel* panelAux;

	/**
	* Value of a pixel in milimeters
	*/
	double _pixelValue;
//--------------------------------------------------------------------------------

	wxStaticText* statictext;
	wxStaticText* statictext1;
	wxStaticText* statictext2;
	wxStaticText* statictext3;
	wxStaticText* statictext4;
	wxStaticText* statictext5;
	wxStaticText* statictext6;

	std::string PANEL;
	std::string PANEL1;
	std::string PANEL2;
	std::string PANEL3;
	std::string PANEL4;
	std::string PANEL5;
	std::string PANEL6;

	wxPanel				*segmentPanel;
	wxPanel				*segmentationPanel;
	wxPanel				*segmentPanelITK;
	wxPanel				*configPanel;
	wxPanel				*spreadPanel;
	interfSpreadPanel	*panelSpread;
	wxWindow			*infoWin;
	wxPanel				*informationPanel;

	wxPanel				*testPanel;
	interfTestPanel		*panelTest;

	wxPanel				*flipPanel;
	interfFlipPanel		*panelFlip;
	
	wxPanel				*mirrorPanel;
	interfMirrorPanel	*panelMirror;

	wxPanel				*thresholdPanel;
	wxPanel				*colorImageLayerPanel;

	bool axisshown;
	bool refLineShown;

	//This attribute contains the panel in charge of adding and removing the corresponding checkboxes in
	//list of contours
	interfToolsSpreadPanel* toolspread;

	/**
	**	This method initializes the tools panel, with the bar and the panel where the contours can be added
	**	and removed.
	**	@params size of the buttons panel
	**	@params sizey of the buttons panel
	**	@params evtHandler this is the class in charge of responding to the events of the buttons
	**/
	wxPanel* initializeToolsPanel(wxWindow* parent, int sizex, int sizey, wxEvtHandler * evtHandler);

	/**
	**	initialize a statictext component of the interface
	**/
	wxStaticText* getText(wxWindow* parent, std::string nom);
	/**
	** initializes a button with data
	**/
	wxButton* getButton(wxWindow* parent);
	/**
	** Puts the panel button and the text int the sizer
	**/
	wxPanel* setMenuTextSizer(wxWindow* parent, wxPanel* panel, wxStaticText* text);


};

#endif

