/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __interfToolsPanelH__
#define __interfToolsPanelH__

#include <string>
#include <wx/wx.h>
#include "mBarRange.h"
#include <wx/grid.h>

class interfConfigurationPanel
	: public wxPanel
{
public:
	interfConfigurationPanel(wxWindow * parent);
	~interfConfigurationPanel();
private:
	void onWidthOfContour(wxScrollEvent& event);
	void onBrigthnessColorWindowLevel(wxScrollEvent& event);
	void OnInterpolation(wxCommandEvent& event);
	void OnShowTextContour(wxCommandEvent& event);
	void OnBeforAfterContour(wxCommandEvent& event);
	void OnBackwareSlice(wxCommandEvent& event);
	void OnFordwareSlice(wxCommandEvent& event);
	wxSlider* 	_withOfContourLine;
	wxSlider* 	_brithtnessWindowLevel;
	wxSlider* 	_brithtnessColorLevel;
	wxCheckBox* _interpolationCheckBox;
	wxCheckBox* _showTextContourCheckBox;
	wxCheckBox* _beforContourCheckBox;
	wxCheckBox* _afterContourCheckBox;
	wxSpinCtrl*	_jumpSpinCtrl;
	wxSpinCtrl*	_shiftSpinCtrl;
};

class interfSpreadPanel
	: public wxPanel
{
public:
	interfSpreadPanel(wxWindow * parent);
	~interfSpreadPanel();
    void appendStringSpread(std::string val);
	void setStringSpread(std::string stringtemp);
private:
	wxRadioBox      *_spreadMethodRadiobox;
	wxStaticText    *_staticTextSpread;
	wxTextCtrl      *_wxtextctrlSpread;
	void onSpreadReset(wxCommandEvent& event);
	void onSpreadAdd(wxCommandEvent& event);
	void onSpreadAddAll(wxCommandEvent& event);
	void onSpreadGo(wxCommandEvent& event);
};

class interfInformationPanel
	: public wxPanel
{
public:
	interfInformationPanel(wxWindow * parent);
	~interfInformationPanel();
    void setStringInfoPanel(wxString tmpString);
	void setRowLabelInfoPanel(int z,wxString tempString);
	void appendCols(int numcols);
	int getNumberCols();
	void setCellValue(int z,int tmpIntA,wxString tempString);
	void setColLabel(int tmpIntB,wxString tmpTitleString);
	wxString getCellValue(int j,int i);
private:
	mBarRange* 		_mbarrangeRangeInformation;
	mBarRange* 		_mbarrangeSliceInformation;
	wxGrid* 		_grid;
	wxRadioBox* 	_informationRadiobox;
	wxRadioBox* 	_radiolstboxContourGroup;
	wxStaticText* 	_staticTextInformation;
	wxCheckBox* 	_XYZValues;
	wxCheckBox* 	_contourImage;
	wxCheckBox* 	_statistics;
	void onInformationContourLabels(wxCommandEvent& event);
	void onExtractInformation(wxCommandEvent& event);
	void onShowResultImages(wxCommandEvent& event);
	void onSaveResults(wxCommandEvent& event);
	void onContourGroup(wxCommandEvent& event);
	void FillGridWithContoursInformation();
	void onRangeSliceInformation(wxCommandEvent& event);
};


class interfFlipPanel
	: public wxPanel
{
public:
	interfFlipPanel(wxWindow * parent);		
	~interfFlipPanel();

	wxRadioBox *_wichContoursRadioBox;

private:
	void onFlipXPressed(wxCommandEvent& event);

	void onFlipYPressed(wxCommandEvent& event);

};


//CMRU 29-08-09-----------------------------------------------------------------------------------------------
/**
* This class represents the calibration panel in the interface icons
*/
class interfCalibrationPanel
	: public wxPanel
{
public:

	/**
	* Initialized the panel
	* @param parent Window who contains the panel
	*/
	interfCalibrationPanel(wxWindow * parent);

	~interfCalibrationPanel();

	/**
	* Manages the event associated with the button of calibration
	*/
	void onCalibrate(wxCommandEvent& event);

private:

	/**
	* Text field of the calibration measure
	*/
	wxTextCtrl * _size;

	/**
	* Radio Box with the measurement units
	*/
	wxRadioBox * _unitsRadiobox;
};

//------------------------------------------------------------------------------------------------------------

#endif


