/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxContourViewPaneL_h_INCLUDED_H__
#define __wxContourViewPaneL_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/scrolwin.h>

//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include "mBarRange.h"
#include "wxMaracas_N_ViewersWidget.h"
#include "vtkImageData.h"
#include "wxVtkBaseView.h"
#include <iostream>
#include <wx/event.h>
#include "wxVtkBaseView_SceneManager.h"
#include "manualContourModel.h"

#include <vtkImageMapToWindowLevelColors.h>


//------------------------------------------------------------------------------------------------------------
// Events declaration
//------------------------------------------------------------------------------------------------------------

BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE(wxINSTANT_CHANGE,400)
END_DECLARE_EVENT_TYPES()


/** file wx

ViewPanel.h */

//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

class wxContourViewPanel : public wxPanel 
{
	public:
	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	wxContourViewPanel( vtkImageData * theShowingImage, wxWindow *parent, const wxPoint& pos=wxDefaultPosition, const wxSize& size = wxDefaultSize,long style= wxDEFAULT_FRAME_STYLE | wxSUNKEN_BORDER, int vertStart=1, int vertEnd=1, int horzStart=1, int horzEnd=1 );
	~wxContourViewPanel();
	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	void setWxEventHandler( wxEvtHandler * theEventHandler );
	void createHorizontalBar(int horzStart, int horzEnd);
	void createVerticalBar(int vertStart, int vertEnd);
	void createViewPanel();
	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events from the horizontal bar
	//------------------------------------------------------------------------------------------------------------
	/**
	* Handles the event wxEVT_TSBAR from the horizontal bar	
	*/
	void onBarrange_Horizontal(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_ACTUAL from the horizontal bar	
	*/
	void onActualChange_Bar_Horizontal(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_START from the horizontal bar	
	*/
	void onStartChange_Bar_Horizontal(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_END from the horizontal bar	
	*/
	void onEndChange_Bar_Horizontal(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_SELECTION_END from the horizontal bar	
	*/
	void onSelectionEnd_Horizontal(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_MOVED from the horizontal bar	
	*/
	void onMovedBar_Horizontal(wxCommandEvent& event);


	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events from the vertical bar
	//------------------------------------------------------------------------------------------------------------

	/**
	* Handles the event wxEVT_TSBAR from the vertical bar	
	*/
	void onBarrange_Vertical(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_ACTUAL from the vertical bar	
	*/
	void onActualChange_Bar_Vertical(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_START from the vertical bar	
	*/
	void onStartChange_Bar_Vertical(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_END from the vertical bar	
	*/
	void onEndChange_Bar_Vertical(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_SELECTION_END from the vertical bar	
	*/
	void onSelectionEnd_Vertical(wxCommandEvent& event);
	/**
	* Handles the event wxEVT_TSBAR_MOVED from the vertical bar	
	*/
	void onMovedBar_Vertical(wxCommandEvent& event);


	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	
	/**
	* Sets the represented values of the vertical bar
	* @param minRepresented In the minimum represented value of the bar
	* @param maxRepresented In the maximum represented value of the bar
	*/
	void setVerticalRepresentedValues( int minRepresented, int maxRepresented );

	/**
	* Sets the represented values of the horizontal bar
	* @param minRepresented In the minimum represented value of the bar
	* @param maxRepresented In the maximum represented value of the bar
	*/
	void setHorizontalRepresentedValues( int minRepresented, int maxRepresented );

	/**
	* Gets the StartVertical value
	* @return The StartVertical
	*/
	int getStartVertical();
	/**
	* Gets the EndVertical value
	* @return The EndVertical
	*/
	int getEndVertical();
	/**
	* Gets the ActualVertical value
	* @return The ActualVertical
	*/
	int getActualVertical();

	/**
	* Sets the StartVertical value
	* @param nwValue The new value for the StartVertical
	*/
	void setStartVertical( int nwValue);
	/**
	* Sets the EndVertical value
	* @param nwValue The new value for the EndVertical
	*/
	void setEndVertical( int nwValue);
	/**
	* Sets the ActualVertical value
	* @param nwValue The new value for the ActualVertical
	*/
	void setActualVertical( int nwValue);

	/**
	* Gets the StartHorizontal value
	* @return The StartHorizontal
	*/
	int getStartHorizontal();
	/**
	* Gets the EndHorizontal value
	* @return The EndHorizontal
	*/
	int getEndHorizontal();
	/**
	* Gets the ActualHorizontal value
	* @return The ActualHorizontal
	*/
	int getActualHorizontal();

	/**
	* Sets the StartHorizontal value
	* @param nwValue The new value for the StartHorizontal
	*/
	void setStartHorizontal( int nwValue);
	/**
	* Sets the EndHorizontal value
	* @param nwValue The new value for the EndHorizontal
	*/
	void setEndHorizontal( int nwValue);
	/**
	* Sets the ActualHorizontal value
	* @param nwValue The new value for the ActualHorizontal
	*/
	void setActualHorizontal( int nwValue);

	/**
	* Sets the horizontal concept values and name
	* @param theHorizontalConcept The name of the concept for setting at the horizontal bar
	* @param minRepresent The minRepresent value of the concept for setting at the horizontal bar
	* @param maxRepresent The maxRepresent value of the concept for setting at the horizontal bar
	* @param minShowed The minShowed value of the concept for setting at the horizontal bar
	* @param maxShowed The maxShowed value of the concept for setting at the horizontal bar
	* @param actualShow The actualShow value of the concept for setting at the horizontal bar
	*/
	void setHorizontalConcept( std::string theHorizontalConcept, int minRepresent, int maxRepresent, int minShowed, int maxShowed, int actualShow ); 

	/**
	* Sets the vertical concept values and name
	* @param theVerticalConcept The name of the concept for setting at the vertical bar
	* @param minRepresent The minRepresent value of the concept for setting at the vertical bar
	* @param maxRepresent The maxRepresent value of the concept for setting at the vertical bar
	* @param minShowed The minShowed value of the concept for setting at the vertical bar
	* @param maxShowed The maxShowed value of the concept for setting at the vertical bar
	* @param actualShow The actualShow value of the concept for setting at the vertical bar
	*/
	void setVerticalConcept( std::string theVerticalConcept, int minRepresent, int maxRepresent, int minShowed, int maxShowed, int actualShow );
	
	/**
	* Sets the horizontal concept name
	* @param theHorizontalConcept The name of the concept for setting at the horizontal bar
	*/
	void setHorizontalConceptName( std::string theHorizontalConcept );

	/**
	* Gets the horizontal concept name
	* @return _horizontalConcept The name of the concept for setting at the horizontal bar
	*/
	std::string  getHorizontalConceptName(  );

	/**
	* Sets the vertical concept name
	* @param theVerticalConcept The name of the concept for setting at the vertical bar
	*/
	void setVerticalConceptName( std::string theVerticalConcept );

	/**
	* Gets the vertical concept name
	* @return _verticalConcept The name of the concept for setting at the vertical bar
	*/
	std::string  	getVerticalConceptName(  );
	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------
	void 			getSpacing( double * spacing );
	wxVtkBaseView*	getWxVtkBaseView();
	double 			getCurrentDeep();
	void			SetVisibleAxis(bool ok);
	int				GetX();
	int				GetY();
	int				GetZ();
	void 			SetXY(int x, int y);
	void			Refresh();


//this method should be deleted
	wxVtkBaseView_SceneManager* getSceneManager();
////////////7
	void initializeScenceManager();
	bool isEditableCControler(std::string theKeyName);
	void removeFromScene(std::string theKeyName);

/////////////////////////////////////////////////////
	void onChangeInstant(wxCommandEvent& event);
    void onCreateMultipleROI (wxCommandEvent& event);
	void onCreateROI (wxCommandEvent& event);
	void onStopCreateROI (wxCommandEvent& event);
	void onChangedDeep (wxCommandEvent& event);
	void onActionButtonPressed(wxCommandEvent& event);
	void removeSceneContours();
	void addNameWrapperToScene();
	std::vector<std::string> getSelectedObjects();
	void RefreshInterface();
	vtkImageData* getImageData();
	void configureViewControlTo(std::string theName,manualBaseModel* manModelContour,double* spc,int typeofcontour);
	int  GetImageDataSizeZ();
	void GetImageDataRange(double *range);
	void SetWidthContour(double width );
	int  getColorWindow();
	int  getWindowLevel();
	void onBrigthnessColorWindowLevel(int colorwindow,int windowlevel);
	void onInterpolation(bool interpolate);
	void onShowTextContour(bool show);
	void onBeforeAfterContour(bool before, bool after);
	void GetPointsOfActualContour( std::vector<double> *vecX, std::vector<double> *vecY, std::vector<double> *vecZ );
	void changeImage(vtkImageData* img);
	void changeDeep();
	void setImageSlice(int z);

private:	
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	wxVtkBaseView_SceneManager		*_sceneManager;
	/*
	* Represents the outer sizer of the ContourViewPanel
	*/
	wxFlexGridSizer					*outSizer;

	/*
	* Represents the panel for viewing
	*/
	wxMaracas_N_ViewersWidget		*theViewPanel;
	/*
	* Represents the vertical barrange
	*/
	mBarRange						*_verticalBar;

	/*
	* Represents the horizontal barrange
	*/
	mBarRange 						*_horizontalBar;
	vtkImageData 					*showingVID;	
	std::string 					_verticalConceptName;
	std::string 					_horizontalConceptName;
	double 							last_spacing[3];
	bool 							_useVerticalBar;
	bool 							_useHorizontalBar;
	wxEvtHandler 					*_eventHandler;
	bool 							_showBeforeContour;
	bool 							_showAfterContour;
	
//EED
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------
	wxVtkMPR2DView *GetwxVtkMPR2DView();
//	DECLARE_CLASS(wxContourViewPanel)
	// any class wishing to process wxWindows events must use this macro
	//DECLARE_EVENT_TABLE()
};
#endif // __wxContour_ViewPanel__

