/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __wxInstantChooserPanel_h_INCLUDED_H__
#define __wxInstantChooserPanel_h_INCLUDED_H__


// -----------------------------------------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// -----------------------------------------------------------------------------------------------------------

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include <string>
#include <vector>
#include  "wxConceptControl.h"
#include <map>
#include "ConceptDataWrap.h"
#include <wx/event.h>
//------------------------------------------------------------------------------------------------------------
// Events declaration
//------------------------------------------------------------------------------------------------------------

BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE(wxINSTANT_CHOOSER_CHANGE,400)
END_DECLARE_EVENT_TYPES()


/** file wxInstantChooserPanel.h */


//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------

class wxInstantChooserPanel : public wxPanel {

	public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------
	
	wxInstantChooserPanel (wxWindow * parent, std::string title, bool theOrientation, bool resolutionALL = false, std::string configurationElem="", std::string groupConfig = "");

	wxInstantChooserPanel (wxWindow * parent,wxWindowID id ,std::string title, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, bool theOrientation=true, std::string configurationElem="", std::string groupConfig = "");

	~wxInstantChooserPanel();

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------
	
	/**
	* Adds a concept to the instant managment. PRE: The concept doesn't exists in the included _concepts.
	* @param aConceptName 
	* @param minV
	* @param maxV
	* @param actualV
	*/
	void addConcept(std::string aConceptName, int minV, int maxV, int actualV);

	void setWxEventHandler( wxEvtHandler * theEventHandler );

	//------------------------------------------------------------------------------------------------------------
	// Methods for capturing events
	//------------------------------------------------------------------------------------------------------------
	void onResolutionSlider( wxScrollEvent& event );

	void onCheckBoxClicked( wxCommandEvent& event );

	void onConceptRelease( wxCommandEvent& event );
	//------------------------------------------------------------------------------------------------------------
	//  Methods for sending events
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	
	ConceptDataWrap * getLastConceptData();

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------
	
	void setInstant(std::vector<int> choiceInstant);
	void setInstant(std::map<std::string,int>* _actualInstant );
	void getInstant(std::vector<int> & choiceInstant);
	void getInstantData(std::map<std::string,int> & choiceInstantData);
	std::map<std::string,int>* getInstantData();
	void setResolutionRangeWithLasUpdate();
	void refreshConceptLabels();
	void setConfiguration(std::string aConfiguration);
	std::string getConfiguration();
	void setResolutionOverAll( bool condition );
	bool getIfResolutionOverAll();
	void setConceptValue( std::string theConceptName, int theValue );
	int getConceptValue( std::string theConceptName );
	ConceptDataWrap * getConceptDataOf( std::string theConceptName );
	bool getIfConceptCheckedAt( std::string theConceptName, int atChecksPosition );
	void onChangeInstant( wxCommandEvent& event );
	void addConcepts(std::vector<std::string> conceptNameVect,std::vector<int> conceptSizeVect);

	private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------
	void initializeResolutionSlider();
	void changeResolutionAtConceptControl( wxConceptControl * theConceptToUpdate );
	void setVerticalMaxSelectedNums( std::string groupMaxVertNums );

	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------

	std::vector<wxConceptControl *> *_concepts;
	wxConceptControl 				*_lastConceptUpdated;
	wxSlider 						*_resolutionSlider;
	wxFlexGridSizer 				*_outSizer;
	bool 							_orientation;
	bool 							_resolutionOverALL;
	std::map<std::string,int>		*_actualInstant;
	std::vector<int> 				_verticalMaxSelected;
	wxEvtHandler 					*_eventHandler;
	std::string 					_configuration;
    
	//DECLARE_CLASS(wxInstantChooserPanel)
	// any class wishing to process wxWindows events must use this macro
	//DECLARE_EVENT_TABLE()
};
#endif 
