/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*=========================================================================

  Program:  ConceptInstantHandler
  Module:    $RCSfile: ConceptInstantHandler.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 12:12:26 $
  Version:   $Revision: 1.8 $
  Objective: Wrapper fo the concepts that subscribe to the instant handler
  Author:    Monica Maria Lozano Romero

  Copyright: (c) 2007
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.


=========================================================================*/

// SYSTEM INCLUDES
#include <iostream>
#include <map>
#include <vector>
#include <string>

// PROJECT INCLUDES

// LOCAL INCLUDES

// FORWARD REFERENCES

/*
* COMMENT
* @param
* @return
*/


#ifndef __CONCEPTINSTANTHANDLER_H_INCLUDED__
#define __CONCEPTINSTANTHANDLER_H_INCLUDED__


#if defined(_WIN32) 
   #ifdef creaEnvironment_BUILD_SHARED
      #define creaEnvironment_EXPORTS __declspec( dllexport )
   #else
      #define creaEnvironment_EXPORTS 
   #endif
#else
   #define creaEnvironment_EXPORTS
#endif


class creaEnvironment_EXPORTS ConceptInstantHandler
{
public:
   //===== CONSTANTS ========
   /*
   * if the concept is  being reproduced in real time
   */
   const static int REAL_TIME=1;
   /*
    * if the concept is being reproduced by doing
    * plus plus to its indexes
    */
   const static int PLUS_PLUS=2;

  
   //====== LIFECYCLE ========
   ConceptInstantHandler(std::string name,int mode,int positionInReproduction);
   ~ConceptInstantHandler();
   //====== OPERATIONS =======
   /*
    * change the actual index by increasing
    * the index until the maximum by the increaseValue
    */
   void nextIndex();
    /*
     * change the actual index by decreasing
     * the index until zero  by the decreaseValue
     */
   void previousIndex();

   //====== INQUIRY =========
   /*
   * @return name
   */
   std::string getName();
   /*
   *	@return PositionInReproduction
   */
   int getPosition();
   /*
   *	@return mode
   */
   int getMode();
   /*
   *	@return increaseValue
   */
   int getIncreaseValue();

   /*
   *	@return decreaseValue
   */
   int getDecreaseValue();
   
   /*
   * @return indexInInstant
   */
   int getIndexInInstant();
   /*
   *	@return actualIndex
*/
   int geActualIndex();
   /*
   *	@return maximumIndex
   */

   int getMaximumIndex();
   /*
   *	@return timeReproduction
   */
   double getTimeReproduction();
   /*
   *	@return scaleTime
   */
   double getScale();

   /*
   * if the actual index is not the maximum index
   */
   bool hasNextIndex();
   /*
   * if the actual index is not zero
   */
   bool hasPreviousIndex();

   /*
   * Get initial time
   */
   double getInitialTime();


   //====== ACCESS ==========
   /*
   *	Sets the name of the concept
   *	@param name, new name
   */
   void setName(std::string name);
   /*
   *	Sets the position of the concept
   *	@param position
   */
   void setPosition(int position);
   /*
   *	Sets the mode of the concept
   *	@param mode, new mode= REAL_TIME or
   *	PLUS_PLUS
   */
   void setMode(int mode);
   /*
   *	Set Increase of the concept
   *	@param increaseValue
   */
   void setIncreaseValue(int increaseValue);

   /*
   *	Set decrease of the concept
   *	@param decreaseValue
   */
   void setDecreaseValue(int decreaseValue);

   /*
   *  Sets  the index of the concept in the instant
   *  @param indexInInstant
   */
   void setIndexInInstant(int indexInInstant);
   /*
   *  Sets  sets the maximum value
   *  @param maximumIndex
   */
   void setMaximumIndex(int maximumIndex);
   /*
   * set the actualIndex
   * @param index
   */
   void setActualIndex(int index);
   /*
   * set the timeReproduction
   * @param time
   */
   void setTimeReproduction(double time);
   /*
   * set the scaleTime
   * @param scale
   */
  void setScale(double scale);
   /*
   * set the actualTime
   * @param actualTime
   */
   void setActualTime(double actualTime);
   /*
   *	reset the initial time
   */
   void resetInitialTime();
   /*
   * Sets the initial time
   */
   void setInitialTime(double time);


   private:

   //======= ATTRIBUTES=======

   /*
   * Name of the concept
   */
   std::string name;
   /*
   *	Mode of changing the instant
   *	REAL_TIME
   *   PLUS_PLUS
   */
   int mode;

   /*
    * position in the reproduction
   */
   int positionInReproduction;
   /*
   * Increment for an instant
   * for default is 1
   */
   int increaseValue;
   /*
   * Decrease for an instant
   * for default is 1
   */
   int decreaseValue;
   /*
   * index in Instant
   */
   int indexInInstant;
   /*
   * index that it is
   */
   int actualIndex;
   /*
   * maximum index that can have in the instant
   */
   int maximumIndex;
   /*
   * Time in miliseconds of the reproduction 
   */
    double timeReproduction;
   /*
   * Scale use for calculate the index
   * of the concept according to the time of reproduction
   * defined in timeReproduction
   * scaleTime=maximumIndex/timeReproduction
   */
   double scaleTime;
   /*
   *	actual time of the reproduction
   *	is in miliseconds
   */
   double actualTime;
   /*
   *	Initial time
   *   is in miliseconds
   */
   double initialTime;

   //====== PRIVATE METHODS=========


   };
#endif
