/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

// SYSTEM INCLUDES


// PROJECT INCLUDES


// LOCAL INCLUDES
#include "Instant.h"


// FORWARD REFERENCES

//NAMESPACE

						//====== LIFECYCLE ========
						template<class P>	
						EnvironmentHandler<P>::EnvironmentHandler(SomeEnvironment<P>* environment)
							{
								this->environment=environment;
							}
						
						template<class P>	
						EnvironmentHandler<P>::~EnvironmentHandler()
							{
								//deleting actual instants
								this->actualInstants.clear();
								//deleting environment
								if(this->environment) delete this->environment;

							}
													
						//====== OPERATIONS =======
						/*
						* change the actual intants associated to the
						* names given
						*/
						template<class P>	
						void EnvironmentHandler<P>::nextInstants(std::vector<std::string> nameConcepts)
							{
								int size,i,indexConcept,indexInConcept,sizeConcept;
								size=nameConcepts.size();
								std::map<std::string,Instant*>::iterator actualInstantsIterator;
								std::string nameConcepti;
								for(i=0;i<size;i++)
									{
										nameConcepti=nameConcepts[i];
										actualInstantsIterator=actualInstants.find(nameConcepti);
										if(actualInstantsIterator!=actualInstants.end())
											{
												Instant* instant=actualInstantsIterator->second;
												indexConcept=environment->getIndexConcept(nameConcepti);
												indexInConcept=instant->getIndexInConcept(indexConcept);
												indexInConcept++;
												sizeConcept=environment->getSizeConcept(nameConcepti);
												if(indexInConcept<sizeConcept)
													instant->setConcept(indexConcept,indexInConcept);
											}
									}

							}
						
						/*
						* add an actual	Instant to a concept, it means, this instant
						* has all index fixed, except the index in the instant of the concept
						* identified by nameConcept
						*/
						template<class P>	
						void EnvironmentHandler<P>::addActualInstantOfCOncept(std::string nameConcept,Instant* instant)
							{
								actualInstants.insert(std::pair<std::string,int>(nameConcept,instant));
							}
						
						/*
						* removes the  pair in the map of actual concepts
						*/
						template<class P>
						void EnvironmentHandler<P>::removeActualInstantOfConcept(std::string nameConcept)
							{
								std::map<std::string,Instant*>::iterator actualInstantsIterator=actualInstants.find(nameConcept);
								if(actualInstantsIterator!=actualInstants.end())
										actualInstants.erase(actualInstantsIterator);
							
							}
						//====== INQUIRY =========
						/*
						* get all the actual instants
						*/
						template<class P>	
						void  EnvironmentHandler<P>::getActualsInstants(std::vector<Instant*>& instantsVector)
							{
								
								std::map<std::string,Instant*>::iterator actualInstantsIterator=
									actualInstants.begin();
								while(actualInstantsIterator!=actualInstants.end())
									{
										Instant* instant=actualInstantsIterator->second;
										instantsVector.push_back(instant);
										actualInstantsIterator++;
									}

							}
						
						/*
						* get the actual instant fot the concept identified by the name
						*/
						template<class P>	
						Instant* EnvironmentHandler<P>::getActualInstant(std::string nameConcept)
							{
								std::map<std::string,Instant*>::iterator actualInstantsIterator=actualInstants.find(nameConcept);
								if(actualInstantsIterator!=actualInstants.end())
									{
										return instant=actualInstantsIterator->second;
										
									}
								else
									return (Instant*)NULL;
							}
						//====== ACCESS ==========
					