/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



// SYSTEM INCLUDES

/*
	#include <iostream>
	#include <vector>
*/

// PROJECT INCLUDES


// LOCAL INCLUDES


// FORWARD REFERENCES




#ifndef __INSTANT_H_INCLUDED__
#define  __INSTANT_H_INCLUDED__

#include "ConceptInstantHandler.h"

class creaEnvironment_EXPORTS Instant
	{
		public:
			
			
			//====== LIFECYCLE ========
			Instant(std::vector<int>* instant);
			Instant();
			Instant(int size);
			~Instant();	

			//====== OPERATIONS =======
			/*
			* Add a new concept to the instant
			* @param indexConcept: index concept that is going
			* to be added of the new concept added to the instant
			* @return --
			* 
			*/
			void addConcept(int value);
			//======= INQUIRY ===========
			/*
			* Returns the value nTuple
			* @return nTuple
			*/
			std::vector<int>* getInstant();
			/*
			* Returns the index of the concept that's
			* in the instant's  concept index
			* @param indexConcept: index of the concept in the instant
			* @return indexInConcept
			*/
			int getIndexInConcept(int indexConcept);
			
			/*
			* returns the number of concepts that the instant has
			* @return nTuple.size()
			*/
			int getSize();
			
			
			/*
			* Compares if the instant given is equals to the nTuple
			* @param instant: instant for compare
			* @return true if is equals to the nTuple, false otherwise
			*/
			bool isEquals(Instant* instant);

			
			//=========== ACCESS ==========
			/*
			* Sets the nTuple
			* @param instant: the vector that's going to be save in
			* nTuple	
			*/
			void setInstant(std::vector<int>* instant);
			
			/*
			* Change the  concept's index saved in the nTuple index (the index
			* that's is for that concept
			* @param indexConcept: Concept that's going to change the value
			* @return--
			* 
			*/
			void setConcept(int indexConcept, int index);
			/*
			* remove a concept from the instant
			* @param indexConcept: Concept that's going to be removec
			* @return true if succesful, false otherwise
			* 
			*/
			bool removeConcept(int indexConcept);

		private:
			
			//=========== ATTRIBUTES==========
			/*
			* The vector that's represent an instant according to the
			* number of concepts that are already defined
			* EXAMPLE
			* concepts: (time,patient), and time's size is 2, patients's size is 2
			* then an possible instant is (1,2)
			* 
			*/
			std::vector<int>* nTuple;
			

	};
#endif



