/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*=========================================================================

  Program:  InstantPlayer
  Module:    $RCSfile: InstantPlayer.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 12:12:26 $
  Version:   $Revision: 1.2 $
  Objective: it do the play methods as stop,pause, play, etc using an instant handler
  Authot:	Monica Maria Lozano Romero

  Copyright: (c) 2007
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.


=========================================================================*/

//	MACRO
#ifndef __INSTANTPLAYER_H_INCLUDED__	
#define __INSTANTPLAYER_H_INCLUDED__	

// SYSTEM INCLUDES



// PROJECT INCLUDES

#include "InstantHandler.h"
#include "ViewerNDimensionsException.h"


// LOCAL INCLUDES

// FORWARD REFERENCES



/*
*	COMMENT
*	@param
*	@return
*/

template <class S>
class InstantPlayer
	{

		public:
			//====== CONSTANTS =======
			const static int REAL_TIME=1;
			const static int PLUS_PLUS=2;

			//========= LYFECYCLE ==========
			InstantPlayer(SomeEnvironment<S>* environment)throw (ViewerNDimensionsException);
			~InstantPlayer();
			
			
			//========= OPERATIONS =========
			/*
			*	When the user wants to play  the dimensions selected by the user
			*	and are already defined
			*	@return 
			*/
			//void play();
			/*
			*	Paused the reproduction of the dimension played
			*	@return
			*/
			void pause();
			/*
			*	Used for change to the next instant in the reproduction
			*	Note: next instant from the instant that's being reproduced
			*	@param loop , if want to do next instant with looping
			*	@return true if the player has changed of instant, false if not
			*/

			bool nextInstant(bool loop=false)throw (ViewerNDimensionsException);
			/*
			*	Used for change to the previous instant in the reproduction
			*	Note: previous instant from the instant that's being reproduced
			*	@return true if the player has changed of instant, false if not
			*/

			bool previousInstant()throw (ViewerNDimensionsException);
			/*
			*	Used for stops the reproduction
			*	POSTCONDITION
			*   in the index value in the index of the dimensin in the actual Instant
			*	is now 0
			*	@return
			*/
			 void stop();
			/*
			* Removes all the concepts handled
			*/
			 void removeAllConcepts();
			
			 /*
			 *	Removes the concept with the name given
			 *	@param nameConcept, name of the concept to remove
			 */
			 void removeConceptToHandled(std::string nameConcept);

			 //====== INQUIRY ========
			 /*
			 *	Returns the things of the actual instant
			 */
			std::vector<S*>* getThingsOfInstant()throw (ViewerNDimensionsException);
			 /*
			 * return the actual instant in the instant handler
			 */
			 Instant* getActualInstant()throw (ViewerNDimensionsException);
			 /*
			 *	 add new concept to handled 
			 *	 @param nameConcept
			 *	 @param mode= REAL_TIME,PLUS_PLUS
			 *	 @param position, position in the player
			 */
			 bool addConceptToHandled(std::string nameConcept,int mode,int position)throw (ViewerNDimensionsException);
			 /*
			 *  Returns the things of the actual instant and its names in the 
			 *	environment
			 */
			 void getThingsWithName(std::vector<std::string>& names,std::vector< S* >& thingsVector)throw (ViewerNDimensionsException);
			 /*
			* Returns the names of the concepts handled and its modes
			* DEPRECATED
			*/
			void getConceptsInfo(std::vector<std::string>& namesConcepts,std::vector<int>& modes);
			 /*
			 *	Returns the name of the concept that handled the real time
			 *	DEPRECATED
			 */
			 void getTimeConcept(std::string& nameConcept);
			 /*
			 * get the number of instants that is playing
			 */
			 int getNumInstantsPlaying();

			  /*
			 *	Returns the names of the concept with its respectively actual value
			 *	@param conceptsAndIndexes is where is going to be save the data searched
			 */
			 void getConceptsActualIndexes(std::map<std::string,int>* conceptsAndIndexes)throw (ViewerNDimensionsException);
			 
			 //========= ACCESS =========
			/*
			 * Sets the time of reproduction of the concept 
			 * that managed the real time
			 * @param time, is in milliseconds
			 */
			 void setTimeReproduction(double time);
			 /*
			 *	Sets the environment
			 */
			 void setEnvironment(SomeEnvironment<S>* environmment);
			 /*
			 *	Set Actual Instant
			 */
			 void setActualInstant(Instant* actualInstant);
			 /*
			 *	Set Actual Instant
			 */
			 void setActualInstant(std::vector<int>* actualInstant);
			 /*
			* Set the increase Value for changing the instant
			*/
			void setIncreaseValue(int increase);
			/*
			* Set the decrease Value for changing the instant
			*/
			void setDecreaseValue(int decrease);

			 /*
			 * Set the mode of a concept that's being handled
			 *	DEPRECATED
			 */
			 //void setModeOfConcept(std::string nameConcept,int mode);
			 /*
			 * Set actual time to the instant handler
			 * DEPRECATED
			 */
			 //void setActualTime(double actualTime);
			 /*
			 * set the modes of the concept that handled the time
			 * to the plus plus mode or real time mode
			 * DEPRECATED
			 */
			// void setTimeConceptToMode(int mode);
			


	private:
		
			/*
			*	 environment
			*/

			SomeEnvironment < S >* environment;

			/*
			* The instant handler
			*/
			InstantHandler < S > * instantHandler;

			/*
			* time reproduction
			* IS IN MILISECONDS
			*/
			//double timeReproduction;

			/*
			* things of instant
			*/
			//std::vector<S*>* thingsOfInstant;
			

		
	};
//include the implementation of the template
#include "InstantPlayer_Txx.h"
#endif



