/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*=========================================================================

  Program:  InstantPlayer
  Module:    $RCSfile: InstantPlayer_Txx.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 12:12:26 $
  Version:   $Revision: 1.2 $
  Objective: it do the play methods as stop,pause, play, etc using an instant handler
  Authot:	Monica Maria Lozano Romero

  Copyright: (c) 2007
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.


=========================================================================*/			
// SYSTEM INCLUDES


// PROJECT INCLUDES


// LOCAL INCLUDES



// FORWARD REFERENCES

//NAMESPACE


			//========= LYFECYCLE ==========
			template<class S>
			InstantPlayer<S>::InstantPlayer(SomeEnvironment<S>* environment)throw (ViewerNDimensionsException)
				{
					this->environment=environment;
					if(environment)
						this->instantHandler= new InstantHandler<S>(this->environment);
					else
						throw new ViewerNDimensionsException("ERROR ENVIRONMENT NULL");
					//this->thingsOfInstant=NULL;
					//this->timeReproduction=100;
				}
			
			template<class S>
			InstantPlayer<S>::~InstantPlayer()
				{
					if(instantHandler) delete instantHandler;
				}
			
			
			//========= OPERATIONS =========
			/*
			*	When the user wants to play  the dimensions selected by the user
			*	and are already defined
			*	@return
			*/
			/*
			template<class S>
			void InstantPlayer<S>::play()
				{
					//setTimeConceptToMode(REAL_TIME);
					instantHandler->nextInstant();
				}
			/*
			*	Paused the reproduction of the dimension played
			*	@return
			*/
			template<class S> 
			void InstantPlayer<S>::pause()
				{
					//setTimeConceptToMode(PLUS_PLUS);
					return;			
				}
			/*
			*	Used for change to the next instant in the reproduction
			*	Note: next instant from the instant that's being reproduced
			*	@param loop , if want to do next instant with looping
			*	@return true if the player has changed of instant, false if not
			*/

			template<class S>
         
			bool InstantPlayer<S>::nextInstant(bool loop)throw (ViewerNDimensionsException)
				{
					//setTimeConceptToMode(PLUS_PLUS);
					bool hasChanged=false;
					bool hasNextInstant=instantHandler->hasNextInstant();
					if(hasNextInstant)
						{
							instantHandler->nextInstant();
							hasChanged=true;
						}
					else if(!loop)
							instantHandler->set();
					else if(loop)
						{
							instantHandler->resetConceptsHandled();
							//instantHandler->set();
							hasChanged=true;
						}
					return hasChanged;
				}
			/*
			*	Used for change to the previous instant in the reproduction
			*	Note: previous instant from the instant that's being reproduced
			*	@return true if the player has changed of instant, false if not
			*/
			template<class S>
			bool InstantPlayer<S>::previousInstant()throw (ViewerNDimensionsException)
				{
					//setTimeConceptToMode(PLUS_PLUS);
					bool hasChanged=false;
					bool hasPreviousInstant=instantHandler->hasPreviousInstant();
					if(hasPreviousInstant)
						{
							instantHandler->previousInstant();
							hasChanged=true;
						}
					else
						instantHandler->set();
					return hasChanged;
						
				}
			/*
			*	Used for stops the reproductioN
			*	@param
			*	@return
			*/
			template<class S>
			 void InstantPlayer<S>::stop()
			 {
				//setTimeConceptToMode(REAL_TIME);
				instantHandler->resetConceptsHandled();
				
			 }
			/*
			* Removes all the concept handled
			*/
			 template<class S>
			 void InstantPlayer<S>::removeAllConcepts()
			 {
				instantHandler->removeAllConcepts();
				
			 }
			
			 /*
			 *	Removes the concept with the name given
			 *	@param nameConcept, name of the concept to remove
			 */
			 template<class S>
			 void InstantPlayer<S>::removeConceptToHandled(std::string nameConcept)
			 {
					instantHandler->removeConceptToHandled(nameConcept);	
			 }
			 //====== INQUIRY ========

			 /*
			 *	Returns the things of the actual instant
			 */
			 template<class S>
			 std::vector<S*>* InstantPlayer<S>::getThingsOfInstant() throw (ViewerNDimensionsException)
				 {					
					Instant* actualInstant= instantHandler->getActualInstant();
					//load the things of the actual instant
					return environment->getThings(actualInstant);
				 }
			 
			  /*
			 * return the actual instant in the instant handler
			 */
			  template<class S>
			 Instant* InstantPlayer<S>::getActualInstant()throw (ViewerNDimensionsException)
				  {
					return instantHandler->getActualInstant();
				  }
			  /*
			 *	 add new concept to handled 
			 *	 @param nameConcept
			 *	 @param mode= REAL_TIME,PLUS_PLUS
			 *	 @param position, position in the player
			 */
			  template<class S>
			  bool InstantPlayer<S>::addConceptToHandled(std::string nameConcept,int mode,int position)throw (ViewerNDimensionsException)
				  {
					return instantHandler->addConceptToHandled(nameConcept,mode,position);
				  }
			 /*
			 *  Returns the things of the actual instants and its names in the 
			 *	environment
			 */
			 template<class S>
			 void InstantPlayer<S>::getThingsWithName(std::vector<std::string>& names,std::vector< S* >& thingsVector)throw (ViewerNDimensionsException)
				 {
					Instant* actualInstant= instantHandler->getActualInstant();
					environment->getThings(names,thingsVector,actualInstant);
				 }
			 /*
			* Returns the names of the concepts handled and its modes
			*	DEPRECATED
			*/
			  template<class S>
			  void InstantPlayer<S>::getConceptsInfo(std::vector<std::string>& namesConcepts,std::vector<int>& modes)
				{
					instantHandler->getConceptsInfo(namesConcepts,modes);
				}
			 /*
			 *	Returns the name of the concept that handled the real time
			 *	DEPRECATED
			 */
			 template<class S>
			 void InstantPlayer<S>::getTimeConcept(std::string& nameConcept)
				 {
					instantHandler->getTimeConcept(nameConcept);
				 }
			 /*
			 * get the number of instants that is playing
			 */
			 template<class S>
			 int InstantPlayer<S>::getNumInstantsPlaying()
				 {
					return instantHandler->getNumOfInstants();
				 }
			  /*
			 *	Returns the names of the concept with its respectively actual value
			 *	@param conceptsAndIndexes is where is going to be save the data searched
			 */
			  template<class S>
			  void InstantPlayer<S>::getConceptsActualIndexes(std::map<std::string,int>* conceptsAndIndexes)throw (ViewerNDimensionsException)
				  {
					std::vector<std::string> conceptsNames;
					environment->getConceptsNames(conceptsNames);
					int instantIndex,i,size,index;
					size=conceptsNames.size();
					Instant* actualInstant= getActualInstant();
					std::string conceptNamei;
					for(i=0;i<size;i++)
						{
							conceptNamei=conceptsNames[i];
							instantIndex=environment->getIndexConcept(conceptNamei);
							index=actualInstant->getIndexInConcept(instantIndex);
							conceptsAndIndexes->insert(std::pair<std::string,int>(conceptNamei,index));
							conceptNamei.clear();

						}
					
				  }

			 //========= ACCESS =========
			 /*
			 * Sets the time of reproduction of the concept 
			 * that managed the real time
			 */
			 template<class S>
			 void InstantPlayer<S>::setTimeReproduction(double time)
				 {
					//this->timeReproduction=time;
					instantHandler->setTimeReproduction(time);
				 }
			 /*
			 *	Sets the environment
			 */
			 template<class S>
			 void InstantPlayer<S>::setEnvironment(SomeEnvironment<S>* environmment)
				 {
					this->environment=environmment;
				 }
			 /*
			 *	Set Actual Instant
			 */
			 template<class S>
			 void InstantPlayer<S>::setActualInstant(Instant* actualInstant)
				  {
					instantHandler->setActualInstant(actualInstant);
				  }
			  /*
			 *	Set Actual Instant
			 */
			 template<class S>
			 void InstantPlayer<S>::setActualInstant(std::vector<int>* actualInstant)
				 {
					Instant* instant=new Instant(actualInstant);
					instantHandler->setActualInstant(instant);
					delete instant;
				 }
			 /*
			* Set the increase Value for changing the instant
			*/
			template<class S>
			void InstantPlayer<S>::setIncreaseValue(int increase)
				{
					instantHandler->setIncreaseValue(increase);
				}
			/*
			* Set the decrease Value for changing the instant
			*/
			template<class S>
			void InstantPlayer<S>::setDecreaseValue(int decrease)
				{
					instantHandler->setDecreaseValue(decrease);
				}

			  /*
			 * Set the mode of a concept that's being handled
			 */
			 /*
			  template<class S>
			 void InstantPlayer<S>::setModeOfConcept(std::string nameConcept,int mode)
				  {
					instantHandler->setModeOfConcept(nameConcept,mode);
				  }
			 /*
			 * Set actual time to the instant handler
			 */
			  /*
			  template<class S>
			 void InstantPlayer<S>::setActualTime(double actualTime)
				  {
					instantHandler->setActualTime(actualTime);
				  }
			  /*
			 * set the modes of the concept that handled the time
			 * to the plus plus mode
			 */
			/* 
			template<class S>
			void InstantPlayer<S>::setTimeConceptToMode(int mode)
				  {
					std::string nameConcept;
					getTimeConcept(nameConcept);
					setModeOfConcept(nameConcept,mode);
				  }
			 */
