/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOGimmick_h_INCLUDED__
#define __creaImageIOGimmick_h_INCLUDED__

#include <creaImageIOSQLiteTreeHandler.h>
#include <creaImageIOTreeHandlerImageAdder.h>
#include <creaImageIOSynchron.h>
#include <creaImageIOSettings.h>



#ifdef _DEBUG
#include <crtdbg.h>
#define DEBUG_NEW new(_NORMAL_BLOCK ,__FILE__, __LINE__)
#else
#define DEBUG_NEW new
#endif


// Only when asked
/*
#ifdef TRACKING_MEMORY_LEAKS
#ifdef WIN32
#pragma warning(disable : 4291)
#endif

void * operator new( size_t size, int line, const char *file );
void * operator new[]( size_t size, int line, const char *file );
void operator delete( void *p );
void operator delete[]( void *p );

#ifdef OMISCID_NEW
#undef OMISCID_NEW
#endif

#define OMISCID_NEW new( __LINE__, __FILE__ )

#else // TRACKING_MEMORY_LEAKS is not defined

#define OMISCID_NEW new

#endif*/


namespace creaImageIO
{
	/**
	* \defgroup Controller Controller
	*/
	/**
	* \defgroup View View
	*/
	/**
	* \defgroup Model Model
	*/
	/**
	* \defgroup GUI Top level graphical user interfaces
	*/
	/**
	* \defgroup IO Image I/O classes
	*/
	/**
	* \defgroup Tree Attributed tree management
	*/
	/**
	* \defgroup Previewer Preview related
	*/

	/**
	* \ingroup Controller
	*/

  //=======================================================================
  /// Central controler of the gimmick application



	/// the selected attributes by end-user
	typedef struct
	{
		// name of database to get attributes
		std::string db;
		// attributes available in this databse
		std::vector<std::string> inside;
		// attributes not available in this databse
		std::vector<std::string> outside;
		//
		bool mult;
	}OutputAttr;

  class CREAIMAGEIO_EXPORT Gimmick
  {
  public:
    /// Ctor
    Gimmick();
    /// Dtor
    ~Gimmick();
    
    ///
    typedef TreeHandlerImageAdder::Progress AddProgress;
    typedef TreeHandlerImageAdder::ProgressCallbackType AddProgressCallbackType;
    
    /// Adds the function f to the list of functions to call 
    /// when addition operations progres.
    /// f is of type AddProgressCallbackType which is:
    /// void (*AddProgressCallbackType)(AddProgress&)
    /// To pass a member function 'f' of an instance 'c' of a class 'C' 
    /// as callback you have to 'bind' it, i.e. call:
    /// ConnectAddProgressObserver ( boost::bind( &C::f , c, _1 ) );
     void ConnectAddProgressObserver( AddProgressCallbackType callback )
    { mImageAdder.ConnectProgressObserver(callback); }
    
    ///
    const AddProgress& GetAddProgress() const { return mImageAdder.GetProgress(); }

    /// Initializes with default values (read/creates databases, etc.)
    void Initialize();

	/// Initializes with the local database descriptor in the path given (read/creates databases, etc.)
	void Initialize(const std::string namedescp, const std::string namedb = "Local Database");
    
    /// Finalize (closes databases, etc.)
    void Finalize();

    /// Sets level for messages "Gimmick!" 
    static void SetMessageLevel(int level);
    /// Sets level for debug messages "Gimmick! DEBUG" 
    static void SetDebugMessageLevel(int level);
    
    /// Type of map from TreeHandler name to TreeHandler*
	typedef std::map<std::string, TreeHandler*> TreeHandlerMapType;

	typedef std::map<std::string, TreeHandler*>::const_iterator ItTreeHandlerMap;

    /// Returns the TreeHandlerMap (ref)
    TreeHandlerMapType& GetTreeHandlerMap() { return mTreeHandlerMap; }
	
    /// Returns the TreeHandlerMap (const ref)
    const TreeHandlerMapType& GetTreeHandlerMap() const
    { return mTreeHandlerMap; }    

    /// Add the files to the given TreeHandler
    void AddFiles(const std::string& handler,
		  const std::vector<std::string>& filenames);

    /// Add a dir to the given TreeHandler
    void AddDir(const std::string& handler, const std::string& path, 
		bool recurse);

	/// Removes a file from the given TreeHandler
	void RemoveFile(const std::string& d, 
			tree::Node* filename);

	///Deletes the given drive name from the databases
	void DeleteDrive(const std::string& drive);
  

	/// Copies the files into the local directory
	void CopyFiles(const std::vector<std::string>& filenames, const std::string& d );
  

	///Synchronizes the loaded data with the database d. If repair is true the database will be updated, otherwise 
	///only a warning sign will be issued
	std::string Synchronize(const std::string& d, bool repair, bool checkAttributes);

    /// Prints the tree handled by the handler
    void Print(const std::string& handler);
	
    ///create a DB from a given descriptor file and for a specific location
	SQLiteTreeHandler* createDB(const std::string &i_name, 
				const std::string &i_locDesc, 
				const std::string &i_locDB);

	/// add an existent DB 
	void addDB(const std::string &i_nameDB, const std::string &i_locationDB);

    /// Returns the TreeHandler with a given name
    TreeHandler* GetTreeHandler(const std::string& name) const;

	/// 
	SQLiteTreeHandler* GetLocalDatabase() { return mLocalDatabase; }

    const SQLiteTreeHandler* GetLocalDatabase() const     { return mLocalDatabase; }

	///Returns the given setting value for the given setting parameter
	void GetSetting(const std::string& name, std::string& value);

	///Updates the settings file
	void UpdateSetting(const std::string& name, const std::string& value);

	/// add DB from Settings file
    void addDBSettings();

	///Edits the field described by the name and key provided with the value given
	void EditField(tree::Node* node, const std::string& d, const std::string& name, const std::string& key, const std::string& val);

	/// Returns the attributes in results described in params
	void GetAttributes(const std::string& d, 
	  const std::string& filename, 
	  const std::vector<std::string>& params, 
	  std::vector<std::string>& results);
  
	/// get Values for given attributes
	void GetAttributes(const std::string filename, std::map<std::string, std::string> &i_res, OutputAttr i_attr);
    
    const std::string& GetHomeDirectory();
    const std::string& GetUserSettingsDirectory();
    void CreateUserSettingsDirectory();
    const std::string& GetLocalDatabasePath();
	
	/// Decide if attributes are available through database
	void fillVectInfos(std::vector<std::string> i_attr, OutputAttr &infos);

    /// Get Add Opertaion summary
    const std::string getSummary();
    //=============================================
  private:
	SQLiteTreeHandler* mLocalDatabase;
	TreeHandlerMapType mTreeHandlerMap;
	Synchronizer* mSynchronizer;

    std::string mCurrentDirectory;
    std::string mHomeDirectory;
    std::string mUserSettingsDirectory;
    std::string mLocalDatabasePath;
	Settings	*mSettings;
    TreeHandlerImageAdder mImageAdder;
	std::string mLocalDBName;
	std::string mLocalDescpName;
  };
  // EO class Gimmick
  //=======================================================================


} // EO namespace creaImageIO

// EOF
#endif  


