/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOImageReader_h_INCLUDED__
#define __creaImageIOImageReader_h_INCLUDED__

#include <creaImageIOSystem.h>
#include <creaImageIOAbstractImageReader.h>

namespace creaImageIO
{

 
  /**
   * \ingroup IO
   * \brief Generic image reader which uses all the specific concrete image reader of the lib (tif, jpg, dicom, ...)
   */
  class CREAIMAGEIO_EXPORT ImageReader : virtual public AbstractImageReader
  {
  public:
    ImageReader();
    ~ImageReader();

    /// Pushes back all kwown extensions (without dot) in the vector given
    void PushBackExtensions(std::vector<std::string>&);

    /// Returns true iff the file is readable
    bool CanRead( const std::string& filename);
    /// Reads and returns the image data. 
    /// Returns an "Unreadable image" picture if fails
    vtkImageData* ReadImage( const std::string& filename);
    
    /// Reads the attributes of the image.
    /// Requested attributes names are provided as keys 
    /// in a string to string map
    /// On return, the values of the map are the values 
    /// of the attributes (empty string if not available).
    void ReadAttributes(const std::string& filename,  tree::AttributeMapType& attr);

    /// Exclude specific readers 
    /// TO DO...
	/// Another function to read attributes for a file
	void getAttributes(const std::string filename, std::map <std::string , std::string> &infos, std::vector<std::string> i_attr);
    
  protected:
    
    /// Register a reader
    void Register( boost::shared_ptr<AbstractImageReader> );

	std::vector<boost::shared_ptr<AbstractImageReader> > mReader;
    vtkImageData* mUnreadableImage;

    std::string mLastFilename;
	boost::shared_ptr<AbstractImageReader> mLastReader;

	bool ShallNotRead( const std::string& filename );

	void UnRegister(const std::string i_val);

	std::vector <std::string> mUnReader;
    
  private:

  }; // class ImageReader
  //=====================================================================



} // namespace creaImageIO



#endif // #ifndef __creaImageIOImageReader_h_INCLUDED__
