/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <boost/program_options.hpp>
#include <map>

#define SETTINGS_DICOM_LIBRARY			"<DICOM Library>"
#define SETTINGS_SYNC_EVENT				"<syncro_event>"
#define SETTINGS_SYNC_FREQ				"<syncro_frequency>"
#define SETTINGS_DBPATH					"<dbpath>"
#define SETTINGS_COPY_PATH				"<copy_path>"
#define SETTINGS_REMOVE_PATIENT_DISPLAY "<remove_patient>"
#define SETTINGS_OUTPUT_ASK				"<output_ask>"
#define SETTINGS_OUTPUT_DIM				"<output_dim>"


namespace creaImageIO
{
    class Settings{
    public :
        Settings(const std::string i_path);
        ~Settings();

        //get the value for a given option
		const std::string getValue(const std::string i_key){return m_SettingsMap[i_key];}
	
		void addDB(const std::string &i_path);

		void removeDB(const std::string &i_path);

		void updateSetting(const std::string& key, const std::string &val);
	
		//write configuration file
		void writeSettingsFile();
		
    private :
		// Settings Key-Value Map
		std::map<std::string, std::string> m_SettingsMap;
		
		//read the configuration file
 		void readSettings(std::vector<std::string> &i_Keys, const std::string &i_file);
        // create the configuration file
        void createFile();
		void writeSettings(std::ofstream &o_filebuf);
		std::string m_SettingsFileName;
		
 		
    };
}
