/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOSynchron_h_INCLUDED__
#define __creaImageIOSynchron_h_INCLUDED__

#include <string>
#include <map>
#include <iostream>
#include <vector>
#include "CppSQLite3.h"

namespace creaImageIO
{
//	using namespace std;
   //================================================================================================================
	///Represents the list of currently added files
    class AddList
    {
      public :
		  ///Key to be added into the database
              std::string key;
			  ///Path of the directory
              std::string path;
			  /// Defines if the operation was recursive or not
              std::string recursive;
			  ///Number of added files
              std::string nbFiles;
			  ///Ctor
              AddList(CppSQLite3Query& res):
			  key(res.getStringField(0)), 
			  path(res.getStringField(1)),
			  recursive(res.getStringField(2)),
			  nbFiles(res.getStringField(3))
              {}
    };
   //================================================================================================================

   //================================================================================================================
	///Represents the list of currently removed files
	class RemoveList
    {
      public :
		  ///Key to be added into the database
              std::string key;
			  ///Path of the remove file
              std::string path;
			  ///Defines if the file was removed or not
              std::string remove;
			  ///Time of the last change of the file
              std::string time;
             ///Ctor
              RemoveList(CppSQLite3Query& res):
			  key(res.getStringField(1)), 
			  path(res.getStringField(2)),
			  remove(res.getStringField(3)),
			  time(res.getStringField(4))
			  {}
    };
   //================================================================================================================
  
   //================================================================================================================
	///In charge of the synchronization of the database and the disk state.
    class Synchronizer
    {
      public:
		  ///Ctor
              Synchronizer( const std::string& path);
			  ///Dtor
              virtual ~Synchronizer();
			  ///Initializes the database
			  void Initialize();
			  ///Inserts an add operation to the database
			  void InsertAddOp(const std::string& path, 
							const std::string& recursive,
							const std::string& nChildren, 
							const std::string& refdb);
			  ///Inserts a file to be ignored
			  void InsertIgnoreFile(const std::string& addKey,
							const std::string& path, 
							const std::string& remove,
							const std::string& time,
							const std::string& refdb);
			  ///Removes an entry that matches the given parameter
			  void RemoveEntry(const std::string i_table, const std::string i_key);
			  ///Removes several entries
			  void RemoveEntries(const std::string i_table, 
											const std::string i_attribute, 
											const std::string i_operand, 
											const std::string i_key);
			  ///Gets the list of AddFiles
			  void GetFileList(std::vector<AddList>& files , const std::string& refdb);
			  ///Gets the list of ignored files
			  void GetIgnoredFiles(const std::string& key, std::vector<std::string> &ignoreList);
			  ///Gets the attribute that matches the parameters
			  std::string GetAttribute(const std::string& attribute, 
										const std::string& table, 
										const std::string& searchParam,
										const std::string& searchValue,
										const std::string& refdb);
			  ///Sets an attribute to an entry that matches the given parameters
			  void SetAttribute(const std::string& attribute, 
										const std::string& table, 
										const std::string& value,
										const std::string& searchParam,
										const std::string& searchValue, 
										const std::string& refdb);
			  // Get the List of indexed files (removed or not)
			  void GetList(const std::string i_db);
			  // Test to not if a file is indexed on db or not
			  bool isIndexed(const std::string filename);
			  // List of all indexed files
			  std::map <std::string, bool> mList;
			  ///The current AddList
              std::vector<AddList>  mAddList;
			  ///The current RemoveList
              std::vector<RemoveList>  mIgnoreList;
      private :
             
              /// The DB
              CppSQLite3DB* mDB;
			  ///Path of the current database
              std::string pathDB;
			  ///Creates a new database
              void CreateDB();
			  ///Updates the AddList
              void UpdateAddList(const std::string& refdb);
			  ///Cleans the list in case operations are no longer useful (0 added files)
              void CleanList(const std::string& refdb);
			  ///Cleans the name (changes slashes and backslashes according to the system)
			  void CleanName(std::string& str) const;
			  ///Gets the ignore list
		      std::vector<std::string> GetIgnoreList(const std::string &i_key);
			  const std::string convert(const std::string &i_word);

    };
   //================================================================================================================

       
} 
// EOF
#endif

