/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIOSystem_INCLUDED__
#define __creaImageIOSystem_INCLUDED__

#include "creaMessageManager.h"

#if defined(_WIN32)

  #ifdef CREAIMAGEIO_EXPORT_SYMBOLS
    #define CREAIMAGEIO_EXPORT __declspec( dllexport )
#else
    #define CREAIMAGEIO_EXPORT __declspec( dllimport )
  #endif
  #define CREAIMAGEIO_CDECL __cdecl
#else
  #define CREAIMAGEIO_EXPORT
  #define CREAIMAGEIO_CDECL
#endif // defined(_WIN32)


namespace creaImageIO
{
  //==============================================================
  inline void RegisterGimmickMessageTypes()
  {
    static bool first_time = true;
    if (first_time)
    {
printf("EED === System.h === RegisterGimmickMessageTypes   \n");		
		crea::MessageManager::RegisterMessageType("Gimmick!",  "Gimmick",1);
		crea::MessageManager::RegisterMessageType("Gimmick! DEBUG",  "Gimmick",0);
		first_time = false;
    } // if
  }
  //==============================================================
  inline void SetGimmickMessageLevel(int l)
  {
    RegisterGimmickMessageTypes();			
    crea::MessageManager::SetMessageLevel("Gimmick!",l);
  }
  //==============================================================
  inline void SetGimmickDebugMessageLevel(int l)		
  {
    RegisterGimmickMessageTypes();			
    crea::MessageManager::SetMessageLevel("Gimmick! DEBUG",l);
  }
  //==============================================================
  
	inline void deleteGimmickDebugMessage()
	{
		delete crea::MessageManager::GetInstance();
	}

#define GimmickMessage(LEV,MESS)			\
  creaMessage( "Gimmick!" , LEV , "[Gimmick!] " << MESS );

#define GimmickDebugMessage(LEV,MESS)					\
  creaDebugMessage("Gimmick! DEBUG",LEV,"[Gimmick!] DEBUG: "<<MESS);

#define GimmickError(MESS)			\
  creaError("[Gimmick!] "<<MESS);

} // namespace

#endif

