/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOTreeDescriptor_h_INCLUDED__
#define __creaImageIOTreeDescriptor_h_INCLUDED__

#include <creaImageIOTreeAttributeMapType.h>
#include <creaImageIOTreeLevelDescriptor.h>


namespace creaImageIO
{
	using namespace std;
  namespace tree
  {
    
    /**
     * \ingroup Tree
     */
    
	///Descriptor of the structure of a Tree (number of levels, descriptors of each level, ...). 
	  //Any Tree has at least one level (level 0) of name "Root"
     
    class Descriptor
    {
    public:
      /// Ctor : creates the mandatory level 0 descriptor called "Root"
      Descriptor();
      /// Destructor
      ~Descriptor();

      /// Loads from a xml description file
      void LoadXML(const std::string& filename);
      /// Creates the default descriptor
      void CreateDefault();

      /// Returns the number of levels of the tree
      unsigned int GetNumberOfLevels() 
      { return (int)mLevelDescriptorList.size(); }

      /// Returns the LevelDescriptor of a given level (const ref)
      const LevelDescriptor& GetLevelDescriptor(int level) const
      { return mLevelDescriptorList[level]; }

      /// Returns the AttributeDescriptorList of a given level (const ref)
	    /// type = 0 all attributes
	  /// type = 1 without ID and PATIENT_ID
      const LevelDescriptor::AttributeDescriptorListType& 
      GetAttributeDescriptorList(int level, int type = 0) const
      { return mLevelDescriptorList[level].GetAttributeDescriptorList(type); }
  
	  
      /// Copy the AttributeDescriptorList without ID tag
	  void CopyAttributeDescriptorList(int level)
	  {
		  mLevelDescriptorList[level].CopyAttributeDescriptorList();
	  }

      /// Adds a LevelDescriptor at the end of the list
      void Add(const LevelDescriptor&);
      
      /// Adds an AttributeDescriptor to level l
      void Add(const AttributeDescriptor&, int l);
      
      
      /// Builds the key to value map of all the attributes of the tree
	void BuildAttributeMap( AttributeMapType& ) const;

      /// The type of LevelDescriptor container
	typedef std::vector<LevelDescriptor> LevelDescriptorListType;
 
      /// Returns the list of tree levels (const)
	const LevelDescriptorListType& GetLevelDescriptorList() const { return mLevelDescriptorList; }

      /// Clears the Descriptor
      void Clear();

	  //Create Attribute Descriptors from a file
	void createDescriptorfromFile(const std::string &i_file);


	/// test if an attribute is present in DescriptionList
	/// return level's name
	const std::string isExist(const std::string i_attr);

    private:
      LevelDescriptorListType mLevelDescriptorList;
      /// Creates the mandatory level 0 descriptor called "Root"
      /// (assumes the list is empty)
      void CreateLevel0Descriptor();
  
    };
    // EO class Descriptor
    //=====================================================================
  } // EO namespace tree

} // EO namespace creaImageIO

// EOF
#endif  
