/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOTreeView_h_INCLUDED__
#define __creaImageIOTreeView_h_INCLUDED__

#include <creaImageIOTreeHandler.h>
#include <creaImageIOTimestampDatabaseHandler.h>
#include <creaImageIOSystem.h>
#include <vtkImageData.h>

namespace creaImageIO
{

  class GimmickView;

  /**
   * \ingroup View
   */
	
  //=====================================================================

  //=====================================================================
  /// Abstract class that handles the view of a Tree through its TreeHandler
  class TreeView
    {
    public:
      /// Ctor
      TreeView(TreeHandler*,GimmickView*);
      /// Virtual destructor
      virtual ~TreeView();

      
      /// Updates the view of a level given the selected items of upper level
      virtual void UpdateLevel( int ) 
      { GimmickError("INTERNAL ERROR : TreeView::UpdateLevel not overloaded");}

	  ///Removes selected nodes
	  virtual void RemoveSelected(std::string &i_save )
	  { GimmickError("INTERNAL ERROR : TreeView::RemoveSelected not overloaded");}

	  ///Validates the selected images
      virtual void ValidateSelectedImages()
	  { GimmickError("INTERNAL ERROR : TreeView::ValidateSelected not overloaded");}
	  
	  ///Returns the last selected level
	  virtual unsigned int GetLastSelectedLevel(){GimmickError("INTERNAL ERROR : TreeView::GetLastSelectedLevel not overloaded");}

	  ///Returns the maximum number of levels
	  virtual int GetNumberOfLevels(){ GimmickError("INTERNAL ERROR : TreeView::GetLevels not overloaded"); }
	  ///Gets the current selections filenames
	  virtual void GetSelectedAsString(std::vector<std::string>&s){ GimmickError("INTERNAL ERROR : TreeView::GetSelectedAsString not overloaded"); }

	  /// Gets the user selected data from the level passed as a parameter
      virtual const std::vector<tree::Node*>& GetSelected(int level){ GimmickError("INTERNAL ERROR : TreeView::GetSelected not overloaded"); }

	  /// Gets the next nodes on the list, be it up(true) or down(false).
      virtual void GetNodes(std::vector<tree::Node*>& nodes, bool direction){ GimmickError("INTERNAL ERROR : TreeView::GetNodes not overloaded"); }

	  /// Gets the attributes that are being shown and the ones that have been blocked on a specific level
	  virtual void GetAttributes(std::vector<std::string>& areShown, std::vector<std::string>& notShown, int level){ GimmickError("INTERNAL ERROR : TreeView::GetAttributes not overloaded"); }
	  
	  ///Sets the non visible attributes and refreshes the GUI
	  virtual void SetNonVisibleAttributes(const std::vector<std::string>& notShown, int level){ GimmickError("INTERNAL ERROR : TreeView::SetNonVisibleAttributes not overloaded"); }

	  ///Creates a new listctrl
	  virtual void CreateCtrl(std::vector<std::string>& notShown, int nlevel){ GimmickError("INTERNAL ERROR : TreeView::CreateCtrl not overloaded"); }

    protected:
      TreeHandler* GetTreeHandler() { return mTreeHandler; }
	  GimmickView* GetGimmickView() { return mGimmickView; }
	 
    private:
      /// The TreeHandler with which it corresponds
      TreeHandler* mTreeHandler;
	  /// The GimmickView which holds the TreeView
      GimmickView* mGimmickView;  

  };
    // EO class TreeView
    //=====================================================================
  
  
} // EO namespace creaImageIO

// EOF
#endif  
