/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOWxGimmickPanel_h_INCLUDED__
#define __creaImageIOWxGimmickPanel_h_INCLUDED__

#ifdef USE_WXWIDGETS

// Signal/slot mechanism for progress events
#include <boost/signals2/signal.hpp>
#include <boost/bind.hpp>

#include <creaImageIOWxGimmickView.h>
#include <creaWx.h>

namespace creaImageIO
{
  /**
   * \ingroup GUI
   */
  //=====================================================================
 //=====================================================================
  class  CREAIMAGEIO_EXPORT WxGimmickPanel : public wxPanel
  {
  public:
    WxGimmickPanel();    
    WxGimmickPanel(wxWindow *parent, 
		   const wxWindowID id,
		   const wxPoint& pos, 
		   const wxSize& size,
		   const std::string i_namedescp , 
		   const std::string i_namedb = "Local Database",
		   int threads = 0);
    
    ~WxGimmickPanel();

      //=============================================
      typedef boost::signals2::signal<void (bool)> SendImageSignalType;
      typedef SendImageSignalType::slot_function_type SendImageCallbackType;
      //=============================================

     //==================================================================
      /// Adds the function f to the list of functions to call 
      /// when the addition progresses.
      /// f is of type ProgressCallbackType which is:
      /// void (*ProgressCallbackType)(Progress&)
      /// To pass a member function 'f' of an instance 'c' of a class 'C' 
      /// as callback you have to 'bind' it, i.e. call:
      /// ConnectSendImageObserver ( boost::bind( &C::f , c, _1 ) );
      void ConnectSendImageObserver(SendImageCallbackType callback);
     //==================================================================

	//===============================================================================================
	//Image Selection
	//===============================================================================================

    void GetSelectedImages(std::vector<vtkImageData*>& s, int dim)
    { 
    	mView->GetSelectedImages(s, dim); 
    }

//EED 28mai2010      Use new mechanism getSelected
//    void GetSelectedImagesInVector(std::vector<vtkImageData*>& s, int dim)
//    { 
//    	mView->GetSelectedImagesInVector(s, dim); 
//    }


	// ----get selected files in an Output structure-------
	// out: vector structure output  < <img, info>, ... >
	// i_attr: list of dicom tags to extract 
	// mult: information of one file or multiple files
	// outmodel: xml-filename that specifies images order..(todo) 
	void getSelected(std::vector<OutStrGimmick> &outG,std::vector< std::string> i_attr, std::vector<std::string> &outFileNames, bool mult, const std::string outmodel)
	{
		mView->getSelectedFiles(outG, i_attr, outFileNames, mult, outmodel);
	}

    void OnSelectedImage(bool t);

    void AddImagesToDB(std::string dir);

    //    DECLARE_EVENT_TABLE();
  private :
    
	boost::shared_ptr<Gimmick>       mGimmick;
    WxGimmickView* mView;

	///The sendImage signal
    SendImageSignalType mSendImageSignal;

  }; // class WxGimmickPanel
  //=====================================================================

  
} // EO namespace creaImageIO


#endif // USE_WIDGETS
// EOF
#endif  
