/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOWxGimmickReaderDialog_h_INCLUDED__
#define __creaImageIOWxGimmickReaderDialog_h_INCLUDED__

#ifdef USE_WXWIDGETS

#include <creaImageIOWxGimmickView.h>
#include "creaImageIOSystem.h"
#include <creaWx.h>
#include "wx/wx.h"
namespace creaImageIO
{
  /**
   * \ingroup GUI
   */

  //=====================================================================
 //=====================================================================
  class CREAIMAGEIO_EXPORT  WxGimmickReaderDialog : public wxDialog
  {
  public:
    WxGimmickReaderDialog();
    WxGimmickReaderDialog(wxWindow *parent, 
			  const wxWindowID id,
			  const std::string i_namedescp , 
			  const std::string i_namedb ,
			  wxString title,
			  const wxPoint& pos,
			  const wxSize& size,
			  int image_min_dim = GIMMICK_2D_IMAGE_SELECTION,
			  int image_max_dim = GIMMICK_3D_IMAGE_SELECTION,
			  int output_dim = NATIVE,
			  int threads = 0);

    boost::shared_ptr<Gimmick> GetGimmick() { return mGimmick; }
    //    typedef WxGimmick ViewType;
    typedef WxGimmickView::EventType EventType;

    ~WxGimmickReaderDialog();

	//===============================================================================================
	//Image Selection
	//===============================================================================================

    void GetSelectedImages(std::vector<vtkImageData*>& s, int dim)
    { mView->GetSelectedImages(s, dim); }

    void GetSelectedImagesInVector(std::vector<vtkImageData*>& s, int dim)
    { mView->GetSelectedImagesInVector(s, dim); }

	// ----get selected files in an Output structure-------
	// out: vector structure output  < <img, info>, ... >
	// i_attr: list of dicom tags to extract 
	// mult: information of one file or multiple files
	// outmodel: xml-filename that specifies images order..(todo) 
	void getSelected(std::vector<OutStrGimmick> &outG,std::vector< std::string> i_attr, std::vector<std::string> &outFileNames, bool mult, const std::string outmodel)
	{
		mView->getSelectedFiles(outG, i_attr, outFileNames, mult, outmodel);
	}

    void GetSelectedFiles(std::vector<std::string>& s) 
    { mView->GetSelectedFiles(s); }

    void OnSelChanged(EventType& event);
    void OnContextualMenu(EventType& event);
    void OnMenuTest(wxCommandEvent& event);
    void OnValid(bool valid);
    void OnExit(){ mView->StopPlayer(); }
	void deleteMessage();
    // void OnButtonOk(wxCommandEvent& event);
    // void OnButtonCancel(wxCommandEvent& event);
	void stopReading()
	{
		mView->stopReader();
	}

  private :

    boost::shared_ptr<Gimmick>   mGimmick;
    WxGimmickView				*mView;

    wxButton					*mOkButton;
    wxButton					*mCancelButton;
	wxBoxSizer 					*mtopsizer;

    enum 
      {
	TVID = 1
	//	OKID = 2,
	//	CANCELID = 3
      };

  }; // class WxGimmickReaderDialog
  //=====================================================================
	
} // EO namespace creaImageIO


#endif // USE_WIDGETS
// EOF
#endif  
