/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOWxGimmickView_h_INCLUDED__
#define __creaImageIOWxGimmickView_h_INCLUDED__

#ifdef USE_WXWIDGETS

#include <creaImageIOGimmickView.h>
#include <creaImageIOWxViewer.h>
#include <creaImageIOWxGimmickTools.h>
#include <creaImageIOListener.h>
#include <creaWx.h>
#include <time.h>

#include "wx/progdlg.h"

#include "wx/wx.h"
#include <wx/splitter.h>
#include <wx/toolbar.h> 
#include <wx/tbarbase.h> 
#include <wx/notebook.h>

namespace creaImageIO
{
  /**
   * \ingroup View
   */
  //=====================================================================
  
  //=====================================================================
  /// Concrete derivative of GimmickView which implements a wxWidgets-based view

  class CREAIMAGEIO_EXPORT WxGimmickView : public wxPanel, virtual public GimmickView
  {
  public:
    
    typedef int EventType;
	OutStrGimmick m_out;
    
    /// Ctor
    WxGimmickView(boost::shared_ptr<Gimmick>, 
		  wxWindow *parent, 
		  const wxWindowID id,
		  const wxPoint& pos, const wxSize& size,
		  int min_dim = GIMMICK_2D_IMAGE_SELECTION,
		  int max_dim = GIMMICK_3D_IMAGE_SELECTION,
		  int number_of_threads = 0);
    /// Virtual destructor
    virtual ~WxGimmickView();
    
    /// Returns the selected files
    ///(overloaded from GimmickView)
    void GetSelectedFiles(std::vector<std::string>& s);
    
	 /// Returns the selected files in output structure
	void getSelectedFiles(std::vector<OutStrGimmick> &outG, std::vector< std::string> out_infos, std::vector<std::string> &outFileNames, bool mult = false, const std::string out_model = "");

    /// Returns the selected Images so that they comply with the 
    /// given parameter(4D) (overloaded from GimmickView)
    void GetSelectedImages(std::vector<vtkImageData*>& s, int dim);
    void GetSelectedImagesInVector(std::vector<vtkImageData*>& s, int dim);


    /// Returns the images indicated by the filenames in the vector 
    /// so that they comply with the given parameter(dim)
    //(overloaded from GimmickView) 
    void GetImages(int dim, const std::vector<std::string>& files, 
		   std::vector<vtkImageData*>& s);
    
    /// Callback called when a selection from a TreeView has changed 
    //(overloaded from GimmickView)
    void OnSelectionChange(const std::vector<tree::Node*>& s, 
			   bool isSelection, int selection, bool mProcess);
    ///Stops the player
    void StopPlayer(){mViewer->StopPlayer();}
    ///Adds a file to ignore
    void AddIgnoreFile(tree::Node* toRemove);
    ///Resets the default image
    void ClearSelection();
	///Copies selected files
    void CopyFiles(const std::vector<std::string>& filenames);
	///Add selected files to the Database
    void AddDir(std::string dirName);
    
    
    ///Sends a request to read the currently selected node and the ones that surround it.
    void ReadImageThreaded(const std::vector<tree::Node*>& sel);

	///Saves the settings to the file
	void OnSaveSettingsCallback(const std::string& copyPath,
	  const std::string& dbPath,
	  const std::string& syncEvent,
	  const std::string& syncFreq);
	
	///Changes listener state
	void OnListenerCallback(const std::string& drive, bool addFiles, bool removeFiles);

	///Acts upon a drive mount
	void OnDriveMount(bool mount);

	///Starts the listening thread on the CD/DVD drive
	void StartListeningThread();

	///Stops the listening thread on the CD/DVD drive
	void StopListeningThread();

	///Called upon when a field has been edited
	void OnFieldsEdited(tree::Node* node, const std::string& name, const std::string& key, const std::string& val);

	///Called upon to return the visible attributes of the current tab
	void GetVisibleAttributes(std::vector<std::string>& shown,std::vector<std::string>& nShown, int level);

	///Called when there has been a change in the visible attributes of a tree view
	void OnAttributesChanged(const std::vector<std::string>& nShown, int level);


  protected:
    /// Creates the tool bar
    void CreateToolBar( ); 
    
    /// Create the tree view for TreeHandler provided 
    /// (overloaded from GimmickView)
    void CreateTreeView( TreeHandler* );
    
    
  private:
	wxBoxSizer 			*mbottom_sizer;
	wxBoxSizer			*msizer;
    /// Is set to true at the end of constructor 
    /// (in order to lock callbacks from threaded objects or event 
    /// before everything is ok)
    bool 				mConstructed;
    /// The ToolBar and the tools
//    wxToolBar			*mToolBar;
    wxPanel             *mToolBar;
    wxToolBarToolBase	*mToolAddFile;
    wxToolBarToolBase	*mToolAddDir;
    wxToolBarToolBase	*mToolRemove;
    wxToolBarToolBase	*mToolAddDatabase;
    wxToolBarToolBase	*mToolHelp;
	wxToolBarToolBase	*mToolSynchronize;
	wxToolBarToolBase	*mToolSettings;
	wxToolBarToolBase	*mToolTools;
    
    wxSplitterWindow	*mSplitter;
    wxPanel				*mBottomPanel;
    wxStaticText 		*mText;
    wxNotebook			*mNotebook;
    
    /// The list of icons 
    wxImageList 		*mIcon;
    void CreateIconList();
    void AddBtnTool(wxPanel *panel, wxBoxSizer *sizerH, int id, wxString label, int idBitmap, wxString tooltip );

    
    boost::shared_ptr<Gimmick> mGimmick;
		
	Listener			*mListener;

    /// Callback for adding files
    void OnAddFiles(wxCommandEvent& event);

    /// Callback for adding dir
    void OnAddDir(wxCommandEvent& event);

    /// Callback for removing files
    void OnRemove(wxCommandEvent& event);

	/// Callback for synchronization
    void OnSynchronize(wxCommandEvent& event);

	/// Callback for settings edition
    void OnSettings(wxCommandEvent& event);

	/// Callback for settings edition
    void OnTools(wxCommandEvent& event);

	/// Callback for Import/Export images
    void OnImportExport(wxCommandEvent& event);

	// Import Images from an archive
	void ImportImages();

	//Export Images to an archive
	void ExportImages();

	///Creates the settings dialog (the pages inside and the information)
	void CreateSettingsDialog(wxNotebook* nb, wxDialog* dial);
    
    /// Display a message box with the last addition statistics
    void DisplayAddSummary();
	time_t  mstart;
	/// Test a directory to know if contains sub-directory to analyze
	bool isNeedRecursive(std::string i_name);

	/// Determines number of files potentially to add to database
	int NumberFilesToAdd(const std::string &dirpath, bool recursive);
    
    /// AddProgress Gimmick callback
    void OnAddProgress( Gimmick::AddProgress& );

#if defined(WIN32)
    /// Called upon to refresh the viewer once there are no actions to be done
    void OnInternalIdle();
#else
	void UpdateWindowUI(long flags = wxUPDATE_UI_NONE);
#endif
	/// callback to add a database
	void OnAddDB(wxCommandEvent& event);
    
	///Create a DB from an Attributes Descriptor files 
	void OnCreateDB(wxCommandEvent& event);

	std::string ExtractName(const std::string &i_name);

	///Edits the fields of a given node
	void CreateEditFieldsDialog(tree::Node* node, std::vector<std::string> names, std::vector<std::string> keys);

	
	/// Display all Dicom Tags
	void DumpTags(const std::string i_filename);
 
	/// Export from Storage to Storage
	void ExportToStorage(const std::vector<std::string> i_filenames);
 
    /// Progress dialog
    wxProgressDialog	*mProgressDialog;

    ///The selection's maximum dimension
    int mSelectionMaxDimension;

    ///The selection's minimum dimension
    int mSelectionMinDimension;

    ///Image previewer
    WxViewer			*mViewer;

    ///Currently Displayed Node
    tree::Node			*mCurImageItemToShow;

    //Pointer holders for images to be shown
 	std::vector< boost::shared_ptr<ImagePointerHolder> > pointers;

	//kill Progress DialogBar
	void killProgress();

    wxString mCurrentDirectory;
    
    DECLARE_EVENT_TABLE()
      };
  // EO class WxGimmickView
  //=====================================================================

} // EO namespace creaImageIO

#endif // USE_WIDGETS
// EOF
#endif
