/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file
 *  \brief Class ThresholdImageViewPanel .
 */

/**
 * \class ThresholdImageViewPanel
 * \brief
 */

#ifndef __ColorLayerImageViewPanel_h__
#define __ColorLayerImageViewPanel_h__


#include <wx/wx.h>
#include <wx/button.h>
#include "ColorLayerImageViewManager.h"
#include "Histogram.h"
#include "HistogramBase.h"

// Borrame
// #include "mBarRange2.h"

//-----------------------------------------------------

//EED 21-08-2010
class wxDlgTransformByDimensionBySpacingByPixel
	{
	public:
		wxDlgTransformByDimensionBySpacingByPixel();
		~wxDlgTransformByDimensionBySpacingByPixel();
		void GetTransformType(wxWindow *parent,
 									double baseSpc[3],
									double layerSpc[3],
									int baseDim[3],
									int layerDim[3],
									wxString message,
									int &typeOfTransformation,
									bool &dlgWxOK) ;
	};



//-----------------------------------------------------

class ColorLayerImageViewPanel
		: public wxPanel
		{
		public:
			ColorLayerImageViewPanel(wxWindow * parent, int min, int max,int opacity, int type);
			~ColorLayerImageViewPanel();
			void onThresholdStop();
			int  GetOpacity();
            bool GetInterpolation();

			virtual void ChangeOpacity();
			ColorLayerImageViewManager* GetColorLayerImageViewManager();
//EED01			ColorLayerImageView* GetColorLayerImageView();
//EED01			void SetColorLayerImageView(ColorLayerImageView* colorLayerImageView);
			bool IsVisible();


			void SetImage(vtkImageData *img);
			void SetFittingMode(int fitting_mode);
			int  GetFittingMode();
			void SetActive(bool active);
			void RefreshView();

		private:
			bool							_active;
			int								_fitting_mode;
			int								_dimBase[3];
			double							_spcBase[3];
			double							_spcOrg[3];
			bool							_thresholdGo;
			ColorLayerImageViewManager  	*_colorLayerImageViewManager;
			wxButton						*_btn_ReadImage;
			wxSlider						*_opacity;
			wxCheckBox						*_interpolationCheckBox;
			wxCheckBox						*_cb_ShowHide;
			wxCheckBox						*_cb_SliceFixDinamic;
			wxSlider						*_sl_SliceImageX;
			wxSlider						*_sl_SliceImageY;
			wxSlider						*_sl_SliceImageZ;

//Borrame
//			mBarRange2						*_barrange2;
			Histogram*						_histogram;
			HistogramMinMaxLevel*			_histogramMinMaxLevel;

			void onReadImage(wxCommandEvent& event);
			void onThresholdChange(wxCommandEvent& event);
			void onThresholdShow(wxCommandEvent& event);
			void onThresholdInterpolation(wxCommandEvent& event);
			void onChangeOpacity(wxScrollEvent& event);
			void onSliceFixDinamic(wxCommandEvent& event);
			void onSliceImage(wxScrollEvent& event);
};

#endif

