/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __ContourCrownWidget_h_INCLUDED_H__
#define __ContourCrownWidget_h_INCLUDED_H__

#include "marTypes.h"
#include "manualContourControler.h"
#include "manualContourModel.h"
#include "manualViewContour.h"
#include "manualRoiControler.h"
#include "manualViewRoi.h"
#include "mBarRange.h"

//JSTG_14-06-08--------------------
#include "ContourPropagation.h"
//---------------------------------
  


  //--------------------------------------------------------------------------
  class creaMaracasVisu_EXPORT wxMaracasCoutourTool : public wxPanel
  {
  public:
	wxMaracasCoutourTool( wxWindow *parent);
    ~wxMaracasCoutourTool();
	void OnContourA(wxCommandEvent &event);   
	void OnContourB(wxCommandEvent &event);   
	void OnContourAB(wxCommandEvent &event);   

	  void Init(wxVtkBaseView *wxvtkbaseview, vtkImageData* imagedata);
	  void ConfigureVTK();

	void GetValuesInsideCrown(	std::vector<double> *pLstValue,
								std::vector<double> *pLstValuePosX,
								std::vector<double> *pLstValuePosY,
								std::vector<double> *pLstValuePosZ);

	wxVtkBaseView *GetWxVtkBaseView();
//EED	void ProcessOutputs();
	vtkImageData *GetVtkImageValueResult();
	vtkImageData *GetVtkImageMaskResult();

//JSTG 26-02-08 --------------------------------------------------------------------------------------------
	void GetSplinePoints	(	std::vector<double> *pLstContourX,
								std::vector<double> *pLstContourY,
								std::vector<double> *pLstContourZ  );

	void SetControlPoints	(	std::vector<double> *InVectorX,
								std::vector<double> *InVectorY, 
								std::vector<double> *InVectorZ );
//JSTG 21-03-08 ----------------------------------------------
	void OnSaveContour		( wxCommandEvent &event );
	void OnSaveControlPoints( wxCommandEvent &event );
//JSTG 11-04-08 ----------------------------------------------
    void EreaseLastContour	( wxCommandEvent& event );
	void EreaseLastCP		( wxCommandEvent& event );
//----------------------------------------------------------------------------------------------------------

  private:
	mBarRange		*mbarrange;
//EED	ContourCrown	*mbbtkContourCrown;
	vtkImageData	*imagedata;
	vtkImageData	*imagedataValueResult;
	vtkImageData	*imagedataMaskResult;
	wxVtkBaseView	*wxvtkbaseview;

//JSTG 26-02-08 ------------------------------------------
	std::vector<double>		_tempCX;
	std::vector<double>		_tempCY;
	std::vector<int>		_tempCZ;
	std::vector<int>		_SizesC;
	std::vector<double>		_tempCPX;
	std::vector<double>		_tempCPY;
	std::vector<int>		_tempCPZ;
	std::vector<int>		_SizesCP;
	std::vector<double>		*pControlVectorX;
	std::vector<double>		*pControlVectorY;
	std::vector<double>		*pControlVectorZ;
	int _zz;
	manualPoint				*_mpoint;
//--------------------------------------------------------
//JSTG_14-06-08-------------------------------------------
	ContourPropagation		*_contprop;
//--------------------------------------------------------

	manualContourControler	*_manContourControl_1;
	manualContourModel		*_mContourModel_1;
	manualViewContour		*_mViewContour_1;

	manualContourControler	*_manContourControl_2;
	manualContourModel		*_mContourModel_2;
	manualViewContour		*_mViewContour_2;

	manualRoiControler		*_manRoiControl;
	manualContourModel		*_mContourModel;
	manualViewRoi			*_mViewRoi;


	bool isInside(int x, int y);
	void GetMinMaxPoint(int *minPoint, int *maxPoint);
	void GetMinMaxPoint(int *minPoint, 
						int *maxPoint, 
						manualViewBaseContour *manualviewbaseecontour,
						manualContourModel *manualcontourmodel );
	int AnalisisContourInside(	int x, 
								int y, 
								manualViewBaseContour *manualviewbaseecontour,
								manualContourModel *manualcontourmodel );
	double GetDataValue(int x, int y);
	void ResetImageResult();
	void PutVtkImageDataResultValue( int x, int y, double value );
	void InitVtkImagesResult();


  };


#endif  // __ContourCrownWidget_h_INCLUDED_H__

