/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __ContourVOIWidget_h_INCLUDED_H__
#define __ContourVOIWidget_h_INCLUDED_H__


#include "manualContourModelRoi.h"
#include "manualRoiControler.h"
#include "manualViewRoi.h"
#include "wxVtkBaseView.h"
#include "wxVtk2DBaseView.h"
#include "mBarRange.h"
#include "marTypes.h"
  
#include "vtkImageMapToColors.h"
#include "vtkImageActor.h"




  class ContourVOIWidget;
  //------------------------------------------------------------------------------------------------------------------------------------
  // Event handling auxiliar class
  //------------------------------------------------------------------------------------------------------------------------------------
  class wxWidgetSliderMinMaxVOI : wxEvtHandler
  {
  public:
	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Constructors ans destructors
	  //--------------------------------------------------------------------------------------------------------------------------------
		wxWidgetSliderMinMaxVOI(ContourVOIWidget *contourtool,mBarRange * modelBarRange);
		~wxWidgetSliderMinMaxVOI();		

	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Min-Max Barrange received events
	  //--------------------------------------------------------------------------------------------------------------------------------
		void onBarrange(wxCommandEvent& event);
		void onActualChange_Bar(wxCommandEvent& event);
		void onStartChange_Bar(wxCommandEvent& event);
		void onEndChange_Bar(wxCommandEvent& event);
		void onSelectionEnd(wxCommandEvent& event);
		void onMovedBar(wxCommandEvent& event);

  private:
	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Attributes
	  //--------------------------------------------------------------------------------------------------------------------------------
	  ContourVOIWidget	*mcontourtool;
	  mBarRange			*modBarRange;
  };


//--------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------

  class creaMaracasVisu_EXPORT ContourVOIWidget : public wxPanel
  {
  public:
	ContourVOIWidget( wxWindow *parent, wxVtkBaseView *wxvtkbaseview , vtkImageData* imagedata);
    ~ContourVOIWidget();
    void ConfigureVTK();

	wxVtkBaseView *GetWxVtkBaseView();
	void GetVOI( int voi[6] );


  private:
	mBarRange				*mbarrange;

	vtkImageData			*imagedata;
	wxVtkBaseView			*wxvtkbaseview;

	manualRoiControler		*_manRoiControl;
	manualContourModel		*_mContourModel;
	manualViewRoi			*_mViewRoi;

  };

#endif  // __ContourVOIWidget_h_INCLUDED_H__

