/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

Program:   wxMaracas
Module:    $RCSfile: CutModelManager.h,v $
Language:  C++
Date:      $Date: 2012/11/15 14:15:49 $
Version:   $Revision: 1.6 $

Copyright: (c) 2002, 2003
License:

This software is distributed WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the above copyright notice for more information.

=========================================================================*/




#ifndef __CutModelManagerH__
#define __CutModelManagerH__

#include <iostream>
#include <stdio.h>
#include <vector>

#include "vtkImageData.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "wxVtkBaseView.h"
#include "wxVtk3DBaseView.h"
#include <vtkPolyDataWriter.h>

#include "CutModelException.h"
#include "CutModelData.h"
#include "CutModelSaveBinInfo.h"

#include "vtkPoints.h"
#include "CutModelPolygon.h"
#include "vtkInteractorStyleTrackballCamera.h"
#include "vtkInteractorStyleCutter.h"
#include "creawxVTKRenderWindowInteractor.h"
#include "vtkImplicitSelectionLoop.h"
#include "vtkPolyDataMapper.h"
#include "vtkSampleFunction.h"
#include "vtkContourFilter.h"
#include "vtkPolyData.h"
#include "vtkActor.h"



class CutModelManager  {

public:
	CutModelManager(std::string path);
	~CutModelManager();

	void setImageData(vtkImageData* img);

	vtkImageData* getImageData();

	void setInteractor(vtkRenderWindowInteractor* interactor);

	void setRenderer(vtkRenderer* renderer);

	void setBaseView(wxVtkBaseView* baseView);

// EED 2022-08-04	
/*
	void onAddCutModel(int id, vtkCommand* observer) throw( CutModelException);
	double* getImageRange()throw( CutModelException);
	void changeOpacity(int id,int opacity)throw( CutModelException);
	void ShowViewBox(int id,bool check)throw( CutModelException);
	void ChangeShape(int id,int selection)throw( CutModelException);
	void changeColor(int id,double r,double g,double b)throw( CutModelException);
	void updateActorDirection(int id)throw( CutModelException);
	void RemoveActor(int id)throw( CutModelException);
	void ExecuteCut(int id, double* range, bool isinside)throw( CutModelException);
	void SaveCutModelData(std::string filename)throw( CutModelException);
	void LoadCutModelData(std::string filename)throw( CutModelException);
	CutModelSaveBinInfo* AddActionUndo(int id, UNDOTYPE type)throw( CutModelException);
	int Undo()throw( CutModelException);
	int Redo()throw( CutModelException);
*/
	void onAddCutModel(int id, vtkCommand* observer);
	double* getImageRange();
	void changeOpacity(int id,int opacity);
	void ShowViewBox(int id,bool check);
	void ChangeShape(int id,int selection);
	void changeColor(int id,double r,double g,double b);
	void updateActorDirection(int id);
	void RemoveActor(int id);
	void ExecuteCut(int id, double* range, bool isinside);
	void SaveCutModelData(std::string filename);
	void LoadCutModelData(std::string filename);
	CutModelSaveBinInfo* AddActionUndo(int id, UNDOTYPE type);
	int Undo();
	int Redo();
	
	vtkImageData* GetResultImage();
	void RefreshActor(int id);
	void ParallelProjectionOn();

	void ParallelProjectionOff();

	void UpdatePolygon(bool mode);

	void ExecuteCutPolygon(bool inOutCut);

	void InitializePolygonInteractorStyle();

private:

	int _currentaction;

// EED 2022-08-04	
//	void checkInvariant() throw( CutModelException);
	void checkInvariant();
	std::string _path;
	vtkImageData* _img;
	vtkImageData* _img2;
	vtkRenderer* _render;
	vtkRenderWindowInteractor* _interactor;

	std::vector<CutModelData*> _vectordata;
	std::vector<CutModelSaveBinInfo*> _undoredo;
// EED 2022-08-04	
//	CutModelData* getCutModelData(int id)throw( CutModelException);
	CutModelData* getCutModelData(int id);

	CutModelPolygon* _polygonCutter;
	vtkPoints *contourPoints ;
	double *contourDirection;	
	vtkInteractorStyleTrackballCamera *interactorstyle;
	vtkInteractorStyleCutter *cutterstyle;
	vtkContourFilter *contour;
	vtkSampleFunction *sample;
	vtkPolyData *actor;
	vtkActor *actor3D;
	vtkImplicitSelectionLoop *loop;
	vtkPolyDataMapper *mapper;

};

#endif 
