/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef __HistogramDialogComboBoxItem__
#define __HistogramDialogComboBoxItem__


// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#include <wx/wx.h>
#include <vector>

class HistogramDialogComboBoxItem
{
public:
	/*
	 Constructor
	*/
	HistogramDialogComboBoxItem();
	HistogramDialogComboBoxItem(int bar_width,int bar_height);
	~HistogramDialogComboBoxItem();

	void SetColors(std::vector<double> greyvect, std::vector<double> redvect, std::vector<double> greenvect, std::vector<double> bluevect);
	void SetTransferFunction(std::vector<double> greyvect, std::vector<double> value);
	wxBitmap GetBitmap();

	std::vector<double> getGreyVector(){return _greyvect;}
	std::vector<double> getRedVector(){return _redvect;}
	std::vector<double> getGreenVector(){return _greenvect;}
	std::vector<double> getBlueVector(){return _bluevect;}

	std::vector<double> getGreyVectorTransfer(){return _greyvecttransfunct;}
	std::vector<double> getValueVector(){return _value;}
private:
	

	std::vector<double> _greyvect;
	std::vector<double> _redvect;
	std::vector<double> _greenvect;
	std::vector<double> _bluevect;

	std::vector<double> _greyvecttransfunct;
	std::vector<double> _value;

	/*
	* Represents the color of the backGround. Default color is the parent color. 
	*/
	wxColour	colourParent;

	int _bar_width;
	int _bar_height;

	wxBitmap* colorBar_Bitmap;
	
};

#endif



