/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================

  Program:   wido
  Module:    $RCSfile: MaximumsDialog.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:55 $
  Version:   $Revision: 1.2 $
  Author: Monica Lozano

  Copyright (c) CREATIS (Centre de Recherche et d'Applications en Traitement de
  l'Image). All rights reserved. See Doc/License.txt or
  http://www.creatis.insa-lyon.fr/Public/wido/License.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

Description:
Is a Dialog that sets two numbers: 
1)a x-value: maximum number that can take the x-axis
2)a y-value: maximum number that can take the y-axis
=========================================================================*/


#ifndef __MAXIMUMSDIALOG__
#define __MAXIMUMSDIALOG__


// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

class MaximumsDialog:public wxDialog
{
public:
	/*
	 Constructor
	*/
	MaximumsDialog(wxWindow *parent,wxString title);
	/*
	 Destructor
	*/
	//~MaximumsDialog();
	/*
	 Returns the X value wrote by the user
	*/
	float getXValue();
	/*
	 Returns the X value wrote by the user
	*/
	float getYValue();

private:
	/*
		TextControl for the x-maxvalue
	*/
	wxTextCtrl      *m_maxX;
	/*
		TextControl for the y-maxvalue
	*/
	wxTextCtrl      *m_maxY;
	/*
	 used to show the names of the text controls
	*/
	wxStaticText    *maxX;
	wxStaticText	*maxY;

	/*
	 ok Button
	*/
	wxButton		*okBtn;
	/*
	 cancel Button
	*/
	wxButton		*cancelBtn;


	DECLARE_CLASS(MaximumsDialog);
	// any class wishing to process wxWindows events must use this macro
	//DECLARE_EVENT_TABLE()
};

#endif


