
#ifndef __ModelShowNPoints_h_INCLUDED__
#define __ModelShowNPoints_h_INCLUDED__


#include <vector>
#include <string>
#include <vtkImageData.h>


class ModelShowNPoints
  {
	public:
	  ModelShowNPoints();
	  ~ModelShowNPoints(); 
	  std::vector<double> 			GetLstPointsX();
	  std::vector<double> 			GetLstPointsY();
	  std::vector<double> 			GetLstPointsZ();
	  void 							GetIdPoint(int id, double *x, double *y, double *z);
	  std::string 					GetIdLabel(int id);
	  std::vector<std::string> 		GetLstLabels();
	  void 							AddPoint(double x, double y, double z, std::string label);
	  double 						DistanceSQ(double dX0, double dY0, double dZ0, double dX1, double dY1, double dZ1);
	  int 							InsertPoint(double x, double y, double z, std::string label);
	  void							SavePoints(std::string filename);
      void                      	SavePoints_(FILE* ff);

      int							ReadPoints(std::string filename);
      int                       	ReadPoints_(FILE* ff);
	  int 							GetNearestPoint();

	  int 							GetLstPointsSize();
	  void 							SetPointId_mReferencePoint(int id);
	  int 							IdInsidePoint();

	  void							SetPointById(int id, std::vector<double> point);
      std::vector<double>           GetPointById(int id);

	  void 							SetReferencePoint(std::vector<double> ppoint);
	  std::vector<double> 			GetReferencePoint();
	  void 							SetImage(vtkImageData *image);
	  std::string 					CleanSpaces(std::string ss);
	  vtkImageData*					GetImage();
	  void 							SetRadio(double radio);
	  double						GetRadio();
	  int 							RenamePoint(std::string label);
	  void 							ErasePoint(int id);
	  void 							SetFirstTime(bool value);
	  bool							GetFirstTime();
      void                      	InversLstPoints();
      int							GetIdCurrentPoint();
      void                          SetIdCurrentPoint(int idPoint);

	private:
	  std::vector<double>           lstPointsX;
	  std::vector<double>           lstPointsY;
	  std::vector<double>          	lstPointsZ;
	  std::vector<std::string>      lstLabels;
	  std::vector<double>      		mReferencePoint;
	  double                		mradio;
	  vtkImageData          		*mimage;
	  bool 							firsttime;
	  int							idCurrentPoint;

  };


#endif // __ModelShowNPoints_h_INCLUDED__


